/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch.buildstrategies.basic;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import jenkins.branch.BranchBuildStrategy;
import jenkins.branch.BranchBuildStrategyDescriptor;
import jenkins.branch.buildstrategies.basic.Messages;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;
import jenkins.scm.api.mixin.ChangeRequestSCMRevision;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class ChangeRequestBuildStrategyImpl
extends BranchBuildStrategy {
    private final boolean ignoreTargetOnlyChanges;

    @DataBoundConstructor
    public ChangeRequestBuildStrategyImpl(boolean ignoreTargetOnlyChanges) {
        this.ignoreTargetOnlyChanges = ignoreTargetOnlyChanges;
    }

    public boolean isIgnoreTargetOnlyChanges() {
        return this.ignoreTargetOnlyChanges;
    }

    public boolean isAutomaticBuild(@NonNull SCMSource source, @NonNull SCMHead head, @NonNull SCMRevision currRevision, @CheckForNull SCMRevision prevRevision) {
        ChangeRequestSCMRevision curr;
        if (!(head instanceof ChangeRequestSCMHead)) {
            return false;
        }
        return !this.ignoreTargetOnlyChanges || !(currRevision instanceof ChangeRequestSCMRevision) || !(prevRevision instanceof ChangeRequestSCMRevision) || !(curr = (ChangeRequestSCMRevision)currRevision).isMerge() || !curr.equivalent((ChangeRequestSCMRevision)prevRevision);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ChangeRequestBuildStrategyImpl that = (ChangeRequestBuildStrategyImpl)((Object)o);
        return this.ignoreTargetOnlyChanges == that.ignoreTargetOnlyChanges;
    }

    public int hashCode() {
        return this.ignoreTargetOnlyChanges ? 1 : 0;
    }

    public String toString() {
        return "ChangeRequestBuildStrategyImpl{ignoreTargetOnlyChanges=" + this.ignoreTargetOnlyChanges + '}';
    }

    @Symbol(value={"buildChangeRequests"})
    @Extension
    public static class DescriptorImpl
    extends BranchBuildStrategyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.ChangeRequestBuildStrategyImpl_displayName();
        }
    }
}

