/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.keyvault;

import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.microsoft.jenkins.keyvault.BaseSecretCredentials;
import com.microsoft.jenkins.keyvault.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.util.FormValidation;
import hudson.util.Secret;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class SecretStringCredentials
extends BaseSecretCredentials
implements StringCredentials {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public SecretStringCredentials(CredentialsScope scope, String id, String description, String servicePrincipalId, String secretIdentifier) {
        super(scope, id, description, servicePrincipalId, secretIdentifier);
    }

    @NonNull
    public Secret getSecret() {
        KeyVaultSecret secretBundle = this.getKeyVaultSecret();
        return Secret.fromString((String)secretBundle.getValue());
    }

    @Extension
    public static class DescriptorImpl
    extends BaseSecretCredentials.DescriptorImpl {
        public String getDisplayName() {
            return Messages.String_Credentials_Diaplay_Name();
        }

        @POST
        public FormValidation doVerifyConfiguration(@AncestorInPath Item owner, @QueryParameter String servicePrincipalId, @QueryParameter String secretIdentifier) {
            if (owner == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                owner.checkPermission(Item.CONFIGURE);
            }
            SecretStringCredentials credentials = new SecretStringCredentials(CredentialsScope.SYSTEM, "", "", servicePrincipalId, secretIdentifier);
            try {
                credentials.getSecret();
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null) {
                    message = Messages.String_Credentials_Validation_Invalid();
                }
                return FormValidation.error((String)message);
            }
            return FormValidation.ok((String)Messages.String_Credentials_Validation_OK());
        }
    }
}

