/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.keyvault;

import com.azure.core.credential.TokenCredential;
import com.azure.security.keyvault.secrets.SecretClient;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.microsoft.azure.util.AzureCredentials;
import java.time.Duration;
import java.util.Objects;

public final class SecretClientCache {
    private static final long MAX_SIZE = 50L;
    private static final Duration EXPIRE_AFTER = Duration.ofMinutes(50L);
    private static final LoadingCache<CacheKey, SecretClient> CACHE = Caffeine.newBuilder().maximumSize(50L).expireAfterWrite(EXPIRE_AFTER).build(SecretClientCache::createClient);

    private SecretClientCache() {
    }

    public static SecretClient get(String credentialsId, String vaultUrl) {
        SecretClient secretClient = (SecretClient)CACHE.get((Object)new CacheKey(credentialsId, vaultUrl));
        if (secretClient == null) {
            throw new RuntimeException(String.format("client null when it should not be, vault url: %s, credentialId: %s", vaultUrl, credentialsId));
        }
        return secretClient;
    }

    public static void invalidateCache() {
        CACHE.invalidateAll();
    }

    private static SecretClient createClient(CacheKey key) {
        TokenCredential keyVaultCredentials = AzureCredentials.getSystemCredentialById(key.credentialsId);
        return AzureCredentials.createKeyVaultClient(keyVaultCredentials, key.vaultUrl);
    }

    private static class CacheKey {
        private final String credentialsId;
        private final String vaultUrl;

        CacheKey(String credentialsId, String vaultUrl) {
            this.credentialsId = credentialsId;
            this.vaultUrl = vaultUrl;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.credentialsId, cacheKey.credentialsId) && Objects.equals(this.vaultUrl, cacheKey.vaultUrl);
        }

        public int hashCode() {
            return Objects.hash(this.credentialsId, this.vaultUrl);
        }
    }
}

