/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.keyvault;

import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.microsoft.azure.util.AzureCredentials;
import com.microsoft.jenkins.keyvault.SecretClientCache;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.net.MalformedURLException;
import java.net.URL;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;

public class BaseSecretCredentials
extends BaseStandardCredentials {
    private static final long serialVersionUID = 1L;
    private transient SecretGetter secretGetter = SecretGetter.DEFAULT;
    private final String credentialId;
    private final String secretIdentifier;

    public BaseSecretCredentials(CredentialsScope scope, String id, String description, String credentialId, String secretIdentifier) {
        super(scope, id, description);
        this.credentialId = credentialId;
        this.secretIdentifier = secretIdentifier;
    }

    @Deprecated
    public String getServicePrincipalId() {
        return this.credentialId;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public String getSecretIdentifier() {
        return this.secretIdentifier;
    }

    protected KeyVaultSecret getKeyVaultSecret() {
        if (this.secretGetter == null) {
            this.secretGetter = SecretGetter.DEFAULT;
        }
        return this.secretGetter.getKeyVaultSecret(this.credentialId, this.secretIdentifier);
    }

    @VisibleForTesting
    void setSecretGetter(SecretGetter secretGetter) {
        this.secretGetter = secretGetter;
    }

    static interface SecretGetter {
        public static final int NAME_POSITION = 2;
        public static final int VERSION_POSITION = 3;
        public static final SecretGetter DEFAULT = (pCredentialId, aSecretIdentifier) -> {
            SecretClient client;
            URL secretIdentifierUrl;
            try {
                secretIdentifierUrl = new URL(aSecretIdentifier);
                client = SecretClientCache.get(pCredentialId, "https://" + secretIdentifierUrl.getHost());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            String[] split = secretIdentifierUrl.getPath().split("/");
            if (split.length == 3) {
                return client.getSecret(split[2]);
            }
            return client.getSecret(split[2], split[3]);
        };

        public KeyVaultSecret getKeyVaultSecret(String var1, String var2);
    }

    protected static abstract class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        protected DescriptorImpl() {
        }

        public ListBoxModel doFillServicePrincipalIdItems(@AncestorInPath Item owner, @QueryParameter(value="servicePrincipalId") String servicePrincipalId) {
            StandardListBoxModel model = new StandardListBoxModel();
            model.includeEmptyValue();
            if (owner == null ? !Jenkins.get().hasPermission(CredentialsProvider.CREATE) && !Jenkins.get().hasPermission(CredentialsProvider.UPDATE) : !owner.hasPermission(CredentialsProvider.CREATE) && !owner.hasPermission(CredentialsProvider.UPDATE)) {
                return model.includeCurrentValue(servicePrincipalId);
            }
            return model.includeCurrentValue(servicePrincipalId).includeAs(Jenkins.getAuthentication2(), owner, AzureCredentials.class).includeAs(ACL.SYSTEM2, owner, AzureCredentials.class);
        }
    }
}

