/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.credentials;

import com.azure.core.credential.TokenCredential;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.microsoft.azure.util.AzureBaseCredentials;
import com.microsoft.azure.util.AzureCredentialUtil;
import com.microsoft.azure.util.AzureCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import io.jenkins.plugins.azuresdk.HttpClientRetriever;
import java.time.Duration;
import java.util.Objects;

public final class BlobServiceClientCache {
    private static final long MAX_SIZE = 50L;
    private static final Duration EXPIRE_AFTER = Duration.ofHours(24L);
    private static final LoadingCache<CacheKey, BlobServiceClient> CACHE = Caffeine.newBuilder().maximumSize(50L).expireAfterWrite(EXPIRE_AFTER).build(BlobServiceClientCache::createClient);

    private BlobServiceClientCache() {
    }

    @CheckForNull
    public static BlobServiceClient get(String credentialsId, String blobServiceEndpoint) {
        return (BlobServiceClient)CACHE.get((Object)new CacheKey(credentialsId, blobServiceEndpoint));
    }

    public static void invalidateCache() {
        CACHE.invalidateAll();
    }

    private static BlobServiceClient createClient(CacheKey key) {
        AzureBaseCredentials credential = AzureCredentialUtil.getCredential(null, key.credentialsId);
        if (credential == null) {
            return null;
        }
        TokenCredential tokenCredential = AzureCredentials.getTokenCredential(credential);
        return new BlobServiceClientBuilder().credential(tokenCredential).endpoint(key.blobServiceEndpoint).httpClient(HttpClientRetriever.get()).buildClient();
    }

    private static class CacheKey {
        private final String credentialsId;
        private final String blobServiceEndpoint;

        CacheKey(String credentialsId, String blobServiceEndpoint) {
            this.credentialsId = credentialsId;
            this.blobServiceEndpoint = blobServiceEndpoint;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.credentialsId, cacheKey.credentialsId) && Objects.equals(this.blobServiceEndpoint, cacheKey.blobServiceEndpoint);
        }

        public int hashCode() {
            return Objects.hash(this.credentialsId, this.blobServiceEndpoint);
        }
    }
}

