/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.awsbeanstalkpublisher.extensions;

import com.amazonaws.regions.Regions;
import com.google.common.base.Joiner;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.ModelObject;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.awsbeanstalkpublisher.AWSEBCredentials;
import org.jenkinsci.plugins.awsbeanstalkpublisher.AWSEBEnvironmentUpdater;
import org.jenkinsci.plugins.awsbeanstalkpublisher.AWSEBUtils;
import org.jenkinsci.plugins.awsbeanstalkpublisher.extensions.AWSEBS3Setup;
import org.jenkinsci.plugins.awsbeanstalkpublisher.extensions.AWSEBSetup;
import org.jenkinsci.plugins.awsbeanstalkpublisher.extensions.AWSEBSetupDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class AWSEBElasticBeanstalkSetup
extends AWSEBSetup {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private final AWSEBCredentials credentials;
    private final Regions awsRegion;
    private final String applicationName;
    private final String versionLabelFormat;
    private final Boolean failOnError;
    private final List<String> environments;
    private List<AWSEBSetup> extensions;

    @DataBoundConstructor
    public AWSEBElasticBeanstalkSetup(Regions awsRegion, String credentials, String applicationName, String environmentList, String versionLabelFormat, Boolean failOnError, List<AWSEBSetup> extensions) {
        this.awsRegion = awsRegion;
        this.credentials = AWSEBCredentials.getCredentialsByString(credentials);
        this.applicationName = applicationName;
        this.environments = new ArrayList<String>();
        for (String next : environmentList.split("\n")) {
            this.environments.add(next);
        }
        this.versionLabelFormat = versionLabelFormat;
        this.failOnError = failOnError;
        this.extensions = extensions;
    }

    public List<AWSEBSetup> getExtensions() {
        return this.extensions == null ? new ArrayList(0) : this.extensions;
    }

    public String getEnvironmentList() {
        return Joiner.on((String)"\n").join(this.environments);
    }

    public List<String> getEnvironments() {
        return this.environments;
    }

    public Regions getAwsRegion() {
        return this.awsRegion == null ? Regions.US_WEST_1 : this.awsRegion;
    }

    public String getApplicationName() {
        return this.applicationName == null ? "" : this.applicationName;
    }

    public String getVersionLabelFormat() {
        return this.versionLabelFormat == null ? "" : this.versionLabelFormat;
    }

    public Boolean getFailOnError() {
        return this.failOnError == null ? false : this.failOnError;
    }

    public AWSEBCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws Exception {
        AWSEBEnvironmentUpdater updater = new AWSEBEnvironmentUpdater(build, launcher, listener, this);
        updater.perform();
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static DescriptorImpl getDesc() {
        return DESCRIPTOR;
    }

    @Extension
    public static class DescriptorImpl
    extends AWSEBSetupDescriptor {
        public String getDisplayName() {
            return "Elastic Beanstalk Application";
        }

        public ListBoxModel doFillCredentialsItems(@QueryParameter String credentials) {
            ListBoxModel items = new ListBoxModel();
            for (AWSEBCredentials creds : AWSEBCredentials.getCredentials()) {
                items.add((ModelObject)creds, creds.toString());
                if (!creds.toString().equals(credentials)) continue;
                ((ListBoxModel.Option)items.get((int)(items.size() - 1))).selected = true;
            }
            return items;
        }

        public FormValidation doCheckEnvironmentList(@QueryParameter String environmentList) {
            List<String> badEnv = AWSEBUtils.getBadEnvironmentNames(environmentList);
            if (badEnv.size() > 0) {
                return FormValidation.error((String)"Bad environment names: %s", (Object[])new Object[]{badEnv.toString()});
            }
            return FormValidation.ok();
        }

        public FormValidation doLoadApplications(@QueryParameter(value="credentials") String credentialsString, @QueryParameter(value="awsRegion") String regionString) {
            AWSEBCredentials credentials = AWSEBCredentials.getCredentialsByString(credentialsString);
            if (credentials == null) {
                return FormValidation.error((String)"Missing valid credentials");
            }
            Regions region = Enum.valueOf(Regions.class, regionString);
            if (region == null) {
                return FormValidation.error((String)"Missing valid Region");
            }
            return FormValidation.ok((String)AWSEBUtils.getApplicationListAsString(credentials, region));
        }

        public FormValidation doLoadEnvironments(@QueryParameter(value="credentials") String credentialsString, @QueryParameter(value="awsRegion") String regionString, @QueryParameter(value="applicationName") String appName) {
            AWSEBCredentials credentials = AWSEBCredentials.getCredentialsByString(credentialsString);
            if (credentials == null) {
                return FormValidation.error((String)"Missing valid credentials");
            }
            Regions region = Enum.valueOf(Regions.class, regionString);
            if (region == null) {
                return FormValidation.error((String)"Missing valid Region");
            }
            if (appName == null) {
                return FormValidation.error((String)"Missing an application name");
            }
            return FormValidation.ok((String)AWSEBUtils.getEnvironmentsListAsString(credentials, region, appName));
        }

        public List<AWSEBSetupDescriptor> getExtensionDescriptors() {
            ArrayList<AWSEBSetupDescriptor> extensions = new ArrayList<AWSEBSetupDescriptor>(1);
            extensions.add(AWSEBS3Setup.getDesc());
            return extensions;
        }
    }
}

