/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.awsbeanstalkpublisher;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationDescription;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.awsbeanstalkpublisher.AWSEBCredentials;

public class AWSEBUtils {
    private static final Pattern ENV_NAME_REGEX = Pattern.compile("[a-zA-Z0-9][-a-zA-Z0-9]{2,21}[a-zA-Z0-9]");
    private static final Logger logger = Logger.getLogger(AWSEBUtils.class.getName());

    public static String formatPath(String mask, Object ... args) {
        return AWSEBUtils.strip(String.format(mask, args).replaceAll("/{2,}", ""));
    }

    public static List<String> getValue(AbstractBuild<?, ?> build, List<String> values) {
        ArrayList<String> newValues = new ArrayList<String>(values.size());
        for (String value : values) {
            if (value.isEmpty()) continue;
            newValues.add(AWSEBUtils.getValue(build, value));
        }
        return newValues;
    }

    public static AmazonS3 getS3(AWSEBCredentials credentials, Regions awsRegion) {
        AWSCredentialsProvider provider = credentials.getAwsCredentials();
        Region region = Region.getRegion((Regions)awsRegion);
        AmazonS3 s3 = (AmazonS3)region.createClient(AmazonS3Client.class, provider, AWSEBUtils.getClientConfig());
        return s3;
    }

    public static String getValue(AbstractBuild<?, ?> build, String value) {
        return AWSEBUtils.strip(AWSEBUtils.replaceMacros(build, value));
    }

    public static String strip(String str) {
        return StringUtils.strip((String)str, (String)"/ ");
    }

    public static String getEnvironmentsListAsString(AWSEBCredentials credentials, Regions region, String appName) {
        List<EnvironmentDescription> environments = AWSEBUtils.getEnvironments(credentials.getAwsCredentials(), region, appName);
        StringBuilder sb = new StringBuilder();
        for (EnvironmentDescription env : environments) {
            sb.append(env.getEnvironmentName());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String getApplicationListAsString(AWSEBCredentials credentials, Regions region) {
        List<ApplicationDescription> apps = AWSEBUtils.getApplications(credentials.getAwsCredentials(), region);
        StringBuilder sb = new StringBuilder();
        for (ApplicationDescription app : apps) {
            sb.append(app.getApplicationName());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static List<String> getBadEnvironmentNames(String environments) {
        ArrayList<String> badEnv = new ArrayList<String>();
        if (environments != null && !environments.isEmpty()) {
            for (String env : environments.split("\n")) {
                if (AWSEBUtils.isValidEnvironmentName(env)) continue;
                badEnv.add(env);
            }
        }
        return badEnv;
    }

    public static boolean isValidEnvironmentName(String name) {
        return ENV_NAME_REGEX.matcher(name).matches();
    }

    public static List<ApplicationDescription> getApplications(AWSCredentialsProvider credentials, Regions region) {
        AWSElasticBeanstalk awseb = AWSEBUtils.getElasticBeanstalk(credentials, Region.getRegion((Regions)region));
        DescribeApplicationsResult result = awseb.describeApplications();
        return result.getApplications();
    }

    public static List<EnvironmentDescription> getEnvironments(AWSCredentialsProvider credentials, Regions region, String appName) {
        AWSElasticBeanstalk awseb = AWSEBUtils.getElasticBeanstalk(credentials, Region.getRegion((Regions)region));
        DescribeEnvironmentsRequest request = new DescribeEnvironmentsRequest().withApplicationName(appName);
        DescribeEnvironmentsResult result = awseb.describeEnvironments(request);
        return result.getEnvironments();
    }

    public static String replaceMacros(AbstractBuild<?, ?> build, String inputString) {
        String returnString = inputString;
        if (build != null && inputString != null) {
            try {
                HashMap messageEnvVars = new HashMap();
                messageEnvVars.putAll(build.getCharacteristicEnvVars());
                messageEnvVars.putAll(build.getBuildVariables());
                messageEnvVars.putAll(build.getEnvironment((TaskListener)new LogTaskListener(logger, Level.INFO)));
                returnString = Util.replaceMacro((String)inputString, messageEnvVars);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Couldn't replace macros in message: ", e);
            }
        }
        return returnString;
    }

    public static AWSElasticBeanstalk getElasticBeanstalk(AWSCredentialsProvider credentials, Region region) {
        AWSElasticBeanstalk awseb = (AWSElasticBeanstalk)region.createClient(AWSElasticBeanstalkClient.class, credentials, AWSEBUtils.getClientConfig());
        return awseb;
    }

    public static ClientConfiguration getClientConfig() {
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setUserAgent(ClientConfiguration.DEFAULT_USER_AGENT);
        return clientConfig;
    }

    public static void log(PrintStream log, String mask, Object ... args) {
        log.println(String.format(mask, args));
    }
}

