/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.awsbeanstalkpublisher;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.S3Location;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.google.common.annotations.VisibleForTesting;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.util.DirScanner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.jenkinsci.plugins.awsbeanstalkpublisher.AWSEBCredentials;
import org.jenkinsci.plugins.awsbeanstalkpublisher.AWSEBUtils;
import org.jenkinsci.plugins.awsbeanstalkpublisher.extensions.AWSEBElasticBeanstalkSetup;
import org.jenkinsci.plugins.awsbeanstalkpublisher.extensions.AWSEBS3Setup;

public class AWSEBS3Uploader {
    private final String keyPrefix;
    private final String bucketName;
    private final String includes;
    private final String excludes;
    private final String rootObject;
    private final boolean isOverwriteExistingFile;
    private final PrintStream log;
    private final String applicationName;
    private final String versionLabel;
    private final Regions awsRegion;
    private final AbstractBuild<?, ?> build;
    private final AWSEBCredentials credentials;
    private String objectKey;
    private String s3ObjectPath;
    private AmazonS3 s3;

    public AWSEBS3Uploader(AbstractBuild<?, ?> build, BuildListener listener, Regions awsRegion, AWSEBCredentials credentials, AWSEBS3Setup s3Setup, String applicationName, String versionLabel) {
        this.credentials = credentials;
        this.build = build;
        this.awsRegion = awsRegion;
        this.log = listener.getLogger();
        this.applicationName = AWSEBUtils.getValue(build, applicationName);
        this.versionLabel = AWSEBUtils.getValue(build, versionLabel);
        this.keyPrefix = AWSEBUtils.getValue(build, s3Setup.getKeyPrefix());
        this.bucketName = AWSEBUtils.getValue(build, s3Setup.getBucketName());
        this.includes = AWSEBUtils.getValue(build, s3Setup.getIncludes());
        this.excludes = AWSEBUtils.getValue(build, s3Setup.getExcludes());
        this.rootObject = AWSEBUtils.getValue(build, s3Setup.getRootObject());
        this.isOverwriteExistingFile = s3Setup.isOverwriteExistingFile();
    }

    public AWSEBS3Uploader(AbstractBuild<?, ?> build, BuildListener listener, AWSEBElasticBeanstalkSetup envSetup, AWSEBS3Setup s3) {
        this(build, listener, envSetup.getAwsRegion(), envSetup.getCredentials(), s3, envSetup.getApplicationName(), envSetup.getVersionLabelFormat());
    }

    public void uploadArchive(AWSElasticBeanstalk awseb) throws Exception {
        if (this.s3 == null) {
            this.s3 = AWSEBUtils.getS3(this.credentials, this.awsRegion);
        }
        this.objectKey = AWSEBUtils.formatPath("%s/%s-%s.zip", this.keyPrefix, this.applicationName, this.versionLabel);
        this.s3ObjectPath = "s3://" + AWSEBUtils.formatPath("%s/%s", this.bucketName, this.objectKey);
        FilePath rootFileObject = new FilePath(this.build.getWorkspace(), AWSEBUtils.getValue(this.build, this.rootObject));
        File localArchive = this.getLocalFileObject(rootFileObject);
        AWSEBUtils.log(this.log, "Uploading file %s as %s", localArchive.getName(), this.s3ObjectPath);
        boolean uploadFile = true;
        try {
            ObjectMetadata meta = this.s3.getObjectMetadata(this.bucketName, this.objectKey);
            String awsMd5 = meta.getContentMD5();
            FileInputStream fis = new FileInputStream(localArchive);
            String ourMd5 = DigestUtils.md5Hex((InputStream)fis);
            fis.close();
            if (ourMd5.equals(awsMd5)) {
                uploadFile = this.isOverwriteExistingFile;
            }
        }
        catch (AmazonS3Exception s3e) {
            if (s3e.getStatusCode() == 403 || s3e.getStatusCode() == 404) {
                uploadFile = true;
            }
            throw s3e;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(this.log);
        }
        catch (IOException e) {
            e.printStackTrace(this.log);
        }
        if (uploadFile) {
            this.s3.putObject(this.bucketName, this.objectKey, localArchive);
        }
        this.createApplicationVersion(awseb);
    }

    @VisibleForTesting
    void setS3(AmazonS3 s3) {
        this.s3 = s3;
    }

    private File getLocalFileObject(FilePath rootFileObject) throws Exception {
        File resultFile = File.createTempFile("awseb-", ".zip");
        if (!rootFileObject.isDirectory()) {
            AWSEBUtils.log(this.log, "Root File Object is a file. We assume its a zip file, which is okay.", new Object[0]);
            rootFileObject.copyTo((OutputStream)new FileOutputStream(resultFile));
        } else {
            AWSEBUtils.log(this.log, "Zipping contents of Root File Object (%s) into tmp file %s (includes=%s, excludes=%s)", rootFileObject.getName(), resultFile.getName(), this.includes, this.excludes);
            rootFileObject.zip((OutputStream)new FileOutputStream(resultFile), (DirScanner)new DirScanner.Glob(this.includes, this.excludes));
        }
        return resultFile;
    }

    public void createApplicationVersion(AWSElasticBeanstalk awseb) {
        AWSEBUtils.log(this.log, "Creating application version %s for application %s for path %s", this.versionLabel, this.applicationName, this.s3ObjectPath);
        CreateApplicationVersionRequest cavRequest = new CreateApplicationVersionRequest().withApplicationName(this.applicationName).withAutoCreateApplication(Boolean.valueOf(true)).withSourceBundle(new S3Location(this.bucketName, this.objectKey)).withVersionLabel(this.versionLabel);
        awseb.createApplicationVersion(cavRequest);
    }
}

