/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.awsbeanstalkpublisher;

import com.amazonaws.regions.Regions;
import com.google.common.base.Joiner;
import hudson.tasks.Recorder;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.awsbeanstalkpublisher.AWSEBCredentials;
import org.jenkinsci.plugins.awsbeanstalkpublisher.extensions.AWSEBElasticBeanstalkSetup;
import org.jenkinsci.plugins.awsbeanstalkpublisher.extensions.AWSEBS3Setup;
import org.jenkinsci.plugins.awsbeanstalkpublisher.extensions.AWSEBSetup;
import org.jenkinsci.plugins.awsbeanstalkpublisher.extensions.AWSEBSetupDescriptor;

public abstract class AWSEBPublisherBackwardsCompatibility
extends Recorder {
    private transient AWSEBCredentials credentials;
    protected transient String bucketName;
    protected transient String keyPrefix;
    @Deprecated
    protected transient String rootObject;
    @Deprecated
    protected transient String includes;
    @Deprecated
    protected transient String excludes;
    @Deprecated
    protected transient Boolean overwriteExistingFile;
    @Deprecated
    protected transient Boolean failOnError;
    protected transient Regions awsRegion;
    protected transient String applicationName;
    protected transient List<String> environments;
    @Deprecated
    protected transient String versionLabelFormat;

    public abstract DescribableList<AWSEBSetup, AWSEBSetupDescriptor> getExtensions();

    protected void readBackExtensionsFromLegacy() {
        try {
            if (StringUtils.isNotBlank((String)this.applicationName) || this.environments != null && this.environments.size() > 0 || StringUtils.isNotBlank((String)this.versionLabelFormat)) {
                ArrayList<AWSEBSetup> s3Setup = new ArrayList<AWSEBSetup>(1);
                if (StringUtils.isNotBlank((String)this.bucketName) || StringUtils.isNotBlank((String)this.keyPrefix)) {
                    s3Setup.add(new AWSEBS3Setup(this.bucketName, this.keyPrefix, this.rootObject, this.includes, this.excludes, this.overwriteExistingFile));
                    this.bucketName = null;
                    this.keyPrefix = null;
                    this.rootObject = null;
                    this.includes = null;
                    this.excludes = null;
                }
                String credentialsName = "";
                if (this.credentials != null) {
                    credentialsName = this.credentials.getDisplayName();
                }
                this.addIfMissing(new AWSEBElasticBeanstalkSetup(this.awsRegion, credentialsName, this.applicationName, Joiner.on((char)'\n').join(this.environments), this.versionLabelFormat, this.failOnError, s3Setup));
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void addIfMissing(AWSEBSetup ext) throws IOException {
        if (this.getExtensions().get(((Object)((Object)ext)).getClass()) == null) {
            this.getExtensions().add((Object)ext);
        }
    }
}

