/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.awsbeanstalkpublisher;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationDescription;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.model.Result;
import hudson.model.Saveable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.awsbeanstalkpublisher.AWSEBCredentials;
import org.jenkinsci.plugins.awsbeanstalkpublisher.AWSEBPublisherBackwardsCompatibility;
import org.jenkinsci.plugins.awsbeanstalkpublisher.AWSEBUtils;
import org.jenkinsci.plugins.awsbeanstalkpublisher.extensions.AWSEBElasticBeanstalkSetup;
import org.jenkinsci.plugins.awsbeanstalkpublisher.extensions.AWSEBSetup;
import org.jenkinsci.plugins.awsbeanstalkpublisher.extensions.AWSEBSetupDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AWSEBPublisher
extends AWSEBPublisherBackwardsCompatibility {
    private DescribableList<AWSEBSetup, AWSEBSetupDescriptor> extensions;

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void addAlias() {
        Items.XSTREAM2.addCompatibilityAlias("org.jenkinsci.plugins.awsbeanstalkpublisher.AWSEBDeploymentPublisher", AWSEBPublisher.class);
    }

    @DataBoundConstructor
    public AWSEBPublisher(List<AWSEBElasticBeanstalkSetup> extensions) {
        this.extensions = new DescribableList(Saveable.NOOP, (Collection)Util.fixNull(extensions));
    }

    @Override
    public DescribableList<AWSEBSetup, AWSEBSetupDescriptor> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new DescribableList(Saveable.NOOP, (Collection)Util.fixNull(this.extensions));
        }
        return this.extensions;
    }

    public Object readResolve() {
        this.readBackExtensionsFromLegacy();
        return this;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        if (build.getResult().isWorseThan(Result.SUCCESS)) {
            return true;
        }
        try {
            return true;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private Set<AWSEBCredentials> credentials;
        private final Regions awsRegion = Regions.DEFAULT_REGION;

        public Regions getAwsRegion() {
            return this.awsRegion;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Deploy into AWS Elastic Beanstalk";
        }

        public List<AWSEBSetupDescriptor> getExtensionDescriptors() {
            ArrayList<AWSEBSetupDescriptor> extensions = new ArrayList<AWSEBSetupDescriptor>(1);
            extensions.add(AWSEBElasticBeanstalkSetup.getDesc());
            return extensions;
        }

        public DescriptorImpl() {
            this.load();
            if (this.credentials != null) {
                AWSEBCredentials.configureCredentials(this.credentials);
            } else if (AWSEBCredentials.getCredentials() != null) {
                this.credentials = AWSEBCredentials.getCredentials();
            }
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            AWSEBCredentials.configureCredentials(req.bindParametersToList(AWSEBCredentials.class, "credential."));
            this.credentials = AWSEBCredentials.getCredentials();
            this.save();
            return super.configure(req, json);
        }

        public Set<AWSEBCredentials> getCredentials() {
            return this.credentials;
        }

        public FormValidation doLoadApplicationsGlobal(@QueryParameter(value="credential.awsAccessKeyId") String accessKey, @QueryParameter(value="credential.awsSecretSharedKey") String secretKey, @QueryParameter(value="awsRegion") String regionString) {
            if (accessKey == null || secretKey == null) {
                return FormValidation.error((String)"Access key and Secret key cannot be empty");
            }
            AWSEBCredentials credentials = new AWSEBCredentials("", accessKey, secretKey);
            Regions region = Enum.valueOf(Regions.class, regionString);
            if (region == null) {
                return FormValidation.error((String)"Missing valid Region");
            }
            List<ApplicationDescription> apps = AWSEBUtils.getApplications(credentials.getAwsCredentials(), region);
            StringBuilder sb = new StringBuilder();
            for (ApplicationDescription app : apps) {
                sb.append(app.getApplicationName());
                sb.append("\n");
            }
            return FormValidation.ok((String)sb.toString());
        }

        public FormValidation doLoadApplications(@QueryParameter(value="credentials") String credentialsString, @QueryParameter(value="awsRegion") String regionString) {
            AWSEBCredentials credentials = AWSEBCredentials.getCredentialsByString(credentialsString);
            if (credentials == null) {
                return FormValidation.error((String)"Missing valid credentials");
            }
            Regions region = Enum.valueOf(Regions.class, regionString);
            if (region == null) {
                return FormValidation.error((String)"Missing valid Region");
            }
            return FormValidation.ok((String)AWSEBUtils.getApplicationListAsString(credentials, region));
        }

        public FormValidation doLoadEnvironments(@QueryParameter(value="credentials") String credentialsString, @QueryParameter(value="awsRegion") String regionString, @QueryParameter(value="applicationName") String appName) {
            AWSEBCredentials credentials = AWSEBCredentials.getCredentialsByString(credentialsString);
            if (credentials == null) {
                return FormValidation.error((String)"Missing valid credentials");
            }
            Regions region = Enum.valueOf(Regions.class, regionString);
            if (region == null) {
                return FormValidation.error((String)"Missing valid Region");
            }
            if (appName == null) {
                return FormValidation.error((String)"Missing an application name");
            }
            return FormValidation.ok((String)AWSEBUtils.getEnvironmentsListAsString(credentials, region, appName));
        }
    }
}

