/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.awsbeanstalkpublisher;

import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class AWSEBEnvironmentUpdaterThread
implements Callable<AWSEBEnvironmentUpdaterThread> {
    private static final int MAX_ATTEMPTS = 15;
    private static final int WAIT_TIME_SECONDS = 30;
    private static final long WAIT_TIME_MILLISECONDS = TimeUnit.SECONDS.toMillis(30L);
    private final EnvironmentDescription envd;
    private final AWSElasticBeanstalk awseb;
    private final DescribeEnvironmentsRequest request;
    private final String environmentId;
    private final PrintStream logger;
    private final String versionLabel;
    private boolean isUpdated = false;
    private boolean isComplete = false;
    private boolean success = false;
    private int nAttempt;

    public AWSEBEnvironmentUpdaterThread(AWSElasticBeanstalk awseb, DescribeEnvironmentsRequest request, EnvironmentDescription envd, PrintStream logger, String versionLabel) {
        this.awseb = awseb;
        this.envd = envd;
        this.logger = logger;
        this.versionLabel = versionLabel;
        this.request = request;
        this.environmentId = envd.getEnvironmentId();
        this.nAttempt = 0;
    }

    private void log(String mask, Object ... args) {
        this.logger.println(String.format(mask, args));
    }

    private void updateEnv() {
        block2: {
            this.log("'%s': Attempt %d/%d", this.envd.getEnvironmentName(), this.nAttempt, 15);
            UpdateEnvironmentRequest uavReq = new UpdateEnvironmentRequest().withEnvironmentId(this.environmentId).withVersionLabel(this.versionLabel);
            this.nAttempt = 0;
            this.isUpdated = true;
            try {
                this.awseb.updateEnvironment(uavReq);
                this.isReady();
            }
            catch (Exception e) {
                this.log("'%s': Problem:", this.envd.getEnvironmentName());
                e.printStackTrace(this.logger);
                if (this.nAttempt < 15) break block2;
                this.log("'%s': Unable to update environment!", this.envd.getEnvironmentName());
                this.isComplete = true;
            }
        }
    }

    private void isReady() {
        block8: {
            try {
                DescribeEnvironmentsResult result = this.awseb.describeEnvironments(this.request);
                EnvironmentDescription lastEnv = null;
                String envName = this.envd.getEnvironmentName();
                for (EnvironmentDescription env : result.getEnvironments()) {
                    if (!env.getEnvironmentId().equals(this.envd.getEnvironmentId())) continue;
                    lastEnv = env;
                    break;
                }
                if (lastEnv == null) {
                    this.isComplete = true;
                    this.log("'%s' is no longer found in ElasticBeanstalk!!!!", envName);
                    return;
                }
                if (lastEnv.getStatus().equals("Ready")) {
                    this.isComplete = true;
                    this.log("'%s': Updated!", envName);
                    this.log("'%s': Current version is:'%s'", envName, lastEnv.getVersionLabel());
                    if (lastEnv.getVersionLabel().equals(this.versionLabel)) {
                        this.success = true;
                        this.log("'%s': Update was successful", envName);
                    } else {
                        this.success = false;
                        this.log("'%s': Update failed, please check the recent events on the AWS console!!!!", envName);
                    }
                } else {
                    this.log("'%s': Waiting for update to finish. Status: %s", envName, lastEnv.getStatus());
                }
            }
            catch (Exception e) {
                this.log("Problem: " + e.getMessage(), new Object[0]);
                if (this.nAttempt < 15) break block8;
                this.log("'%s': unable to get environment status.", this.envd.getEnvironmentName());
                this.isComplete = true;
            }
        }
    }

    @Override
    public AWSEBEnvironmentUpdaterThread call() throws Exception {
        this.run();
        return this;
    }

    public void printResults() {
        StringBuilder status = new StringBuilder();
        status.append("'");
        status.append(this.envd.getEnvironmentName());
        status.append("': ");
        if (this.success) {
            status.append("Completed successfully.");
        } else if (this.isUpdated) {
            status.append("Was updated, but couldn't be verified!");
        } else {
            status.append("Failed to be updated!!");
        }
        this.log(status.toString(), new Object[0]);
    }

    public boolean isSuccessfull() {
        return this.success;
    }

    public void run() {
        while (!this.isComplete) {
            if (this.isUpdated) {
                this.isReady();
            } else {
                this.updateEnv();
            }
            if (this.isComplete) continue;
            try {
                this.log("'%s': Pausing update for %d seconds", this.envd.getEnvironmentName(), 30);
                Thread.sleep(WAIT_TIME_MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace(this.logger);
            }
        }
    }
}

