/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.awsbeanstalkpublisher;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jenkinsci.plugins.awsbeanstalkpublisher.AWSEBEnvironmentUpdaterThread;
import org.jenkinsci.plugins.awsbeanstalkpublisher.AWSEBS3Uploader;
import org.jenkinsci.plugins.awsbeanstalkpublisher.AWSEBUtils;
import org.jenkinsci.plugins.awsbeanstalkpublisher.extensions.AWSEBElasticBeanstalkSetup;
import org.jenkinsci.plugins.awsbeanstalkpublisher.extensions.AWSEBS3Setup;
import org.jenkinsci.plugins.awsbeanstalkpublisher.extensions.AWSEBSetup;

public class AWSEBEnvironmentUpdater {
    private static final int MAX_THREAD_COUNT = 5;
    private final AbstractBuild<?, ?> build;
    private final BuildListener listener;
    private final PrintStream log;
    private final AWSEBElasticBeanstalkSetup envSetup;
    private final List<String> environments;
    private final String applicationName;
    private final String versionLabel;
    private final AWSElasticBeanstalk awseb;
    private final boolean failOnError;

    public AWSEBEnvironmentUpdater(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, AWSEBElasticBeanstalkSetup envSetup) {
        this.build = build;
        this.listener = listener;
        this.log = listener.getLogger();
        this.envSetup = envSetup;
        this.environments = AWSEBUtils.getValue(build, envSetup.getEnvironments());
        this.applicationName = AWSEBUtils.getValue(build, envSetup.getApplicationName());
        this.versionLabel = AWSEBUtils.getValue(build, envSetup.getVersionLabelFormat());
        this.failOnError = envSetup.getFailOnError();
        AWSCredentialsProvider provider = envSetup.getCredentials().getAwsCredentials();
        Region region = Region.getRegion((Regions)envSetup.getAwsRegion());
        this.awseb = AWSEBUtils.getElasticBeanstalk(provider, region);
    }

    public void perform() throws Exception {
        for (AWSEBSetup extension : this.envSetup.getExtensions()) {
            if (!(extension instanceof AWSEBS3Setup)) continue;
            AWSEBS3Setup s3 = (AWSEBS3Setup)extension;
            AWSEBS3Uploader uploader = new AWSEBS3Uploader(this.build, this.listener, this.envSetup, s3);
            uploader.uploadArchive(this.awseb);
        }
        this.updateEnvironments();
    }

    public void updateEnvironments() {
        DescribeEnvironmentsRequest request = this.environments != null && !this.environments.isEmpty() ? new DescribeEnvironmentsRequest().withApplicationName(this.applicationName).withEnvironmentNames(this.environments) : new DescribeEnvironmentsRequest().withApplicationName(this.applicationName);
        try {
            this.updateEnvironments(request);
        }
        catch (Exception e) {
            e.printStackTrace(this.log);
        }
    }

    public void updateEnvironments(DescribeEnvironmentsRequest request) throws InterruptedException {
        DescribeEnvironmentsResult result = this.awseb.describeEnvironments(request);
        List envList = result.getEnvironments();
        if (envList.size() <= 0) {
            AWSEBUtils.log(this.log, "No environments found matching applicationName:%s with environments:%s", this.applicationName, this.environments);
            this.listener.finished(Result.SUCCESS);
            return;
        }
        ExecutorService pool = Executors.newFixedThreadPool(5);
        ArrayList<AWSEBEnvironmentUpdaterThread> updaters = new ArrayList<AWSEBEnvironmentUpdaterThread>();
        for (EnvironmentDescription envd : envList) {
            AWSEBUtils.log(this.log, "Environment found (environment id='%s', name='%s'). Attempting to update environment to version label '%s'", envd.getEnvironmentId(), envd.getEnvironmentName(), this.versionLabel);
            updaters.add(new AWSEBEnvironmentUpdaterThread(this.awseb, request, envd, this.log, this.versionLabel));
        }
        List<Future<AWSEBEnvironmentUpdaterThread>> results = pool.invokeAll(updaters);
        this.printResults(this.listener, results);
    }

    private void printResults(BuildListener listener, List<Future<AWSEBEnvironmentUpdaterThread>> results) {
        PrintStream log = listener.getLogger();
        boolean hadFailures = false;
        for (Future<AWSEBEnvironmentUpdaterThread> future : results) {
            try {
                AWSEBEnvironmentUpdaterThread result = future.get();
                hadFailures |= result.isSuccessfull();
                result.printResults();
            }
            catch (Exception e) {
                AWSEBUtils.log(log, "Unable to get results from update", new Object[0]);
                e.printStackTrace(log);
            }
        }
        if (this.failOnError && hadFailures) {
            listener.finished(Result.FAILURE);
        } else {
            listener.finished(Result.SUCCESS);
        }
    }
}

