/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.awsbeanstalkpublisher;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.internal.StaticCredentialsProvider;
import hudson.model.ModelObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;

public class AWSEBCredentials
implements ModelObject {
    private final String name;
    private final String awsAccessKeyId;
    private final String awsSecretSharedKey;
    private static final Set<AWSEBCredentials> credentials = new HashSet<AWSEBCredentials>();

    public String getName() {
        return this.name;
    }

    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public String getAwsSecretSharedKey() {
        return this.awsSecretSharedKey;
    }

    public AWSEBCredentials() {
        this.name = null;
        this.awsAccessKeyId = null;
        this.awsSecretSharedKey = null;
    }

    @DataBoundConstructor
    public AWSEBCredentials(String name, String awsAccessKeyId, String awsSecretSharedKey) {
        this.name = name;
        this.awsAccessKeyId = awsAccessKeyId;
        this.awsSecretSharedKey = awsSecretSharedKey;
    }

    public String getDisplayName() {
        return this.name + " : " + this.awsAccessKeyId;
    }

    public AWSCredentialsProvider getAwsCredentials() {
        AWSCredentialsProviderChain credentials = new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new StaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.getAwsAccessKeyId(), this.getAwsSecretSharedKey()))});
        return credentials;
    }

    public static void configureCredentials(Collection<AWSEBCredentials> toAdd) {
        credentials.clear();
        credentials.addAll(toAdd);
    }

    public static Set<AWSEBCredentials> getCredentials() {
        return credentials;
    }

    public static AWSEBCredentials getCredentialsByString(String credentialsString) {
        Set<AWSEBCredentials> credentials = AWSEBCredentials.getCredentials();
        for (AWSEBCredentials credential : credentials) {
            if (!credential.toString().equals(credentialsString)) continue;
            return credential;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AWSEBCredentials)) {
            return false;
        }
        AWSEBCredentials creds = (AWSEBCredentials)o;
        boolean isSame = this.awsAccessKeyId.equals(creds.awsAccessKeyId);
        return isSame &= this.name.equals(creds.name);
    }

    public String toString() {
        return this.name + " : " + this.awsAccessKeyId;
    }

    public int hashCode() {
        return this.awsAccessKeyId.hashCode();
    }
}

