/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import hudson.util.Secret;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.ansible.AnsibleInvocationException;
import org.jenkinsci.plugins.ansible.CLIRunner;
import org.jenkinsci.plugins.ansible.ExtraVar;
import org.jenkinsci.plugins.ansible.Inventory;
import org.jenkinsci.plugins.ansible.Utils;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

abstract class AbstractAnsibleInvocation<T extends AbstractAnsibleInvocation<T>> {
    protected final EnvVars envVars;
    protected final TaskListener listener;
    protected final Run<?, ?> build;
    protected final Map<String, String> environment;
    protected String exe;
    protected int forks;
    protected boolean become;
    protected String becomeUser;
    protected boolean sudo;
    protected String sudoUser;
    protected StandardCredentials vaultCredentials;
    protected FilePath vaultTmpPath = null;
    protected StandardUsernameCredentials credentials;
    protected List<ExtraVar> extraVars;
    protected String additionalParameters;
    private FilePath key = null;
    private FilePath script = null;
    private FilePath vaultPassword = null;
    private Inventory inventory;
    private boolean copyCredentialsInWorkspace = false;
    private final FilePath ws;

    protected AbstractAnsibleInvocation(String exe, Run<?, ?> build, FilePath ws, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException, AnsibleInvocationException {
        this.build = build;
        this.ws = ws;
        this.envVars = envVars;
        this.environment = new HashMap<String, String>((Map<String, String>)this.envVars);
        this.listener = listener;
        this.exe = exe;
        if (exe == null) {
            throw new AnsibleInvocationException("Ansible executable not found, check your installation.");
        }
    }

    protected ArgumentListBuilder appendExecutable(ArgumentListBuilder args) {
        args.add(this.exe);
        return args;
    }

    public T setInventory(Inventory inventory) {
        this.inventory = inventory;
        return (T)this;
    }

    protected ArgumentListBuilder appendInventory(ArgumentListBuilder args) throws IOException, InterruptedException, AnsibleInvocationException {
        if (this.inventory == null) {
            return args;
        }
        this.inventory.addArgument(args, this.ws, this.envVars, this.listener);
        return args;
    }

    public T setForks(int forks) {
        this.forks = Math.max(forks, 0);
        return (T)this;
    }

    public ArgumentListBuilder appendForks(ArgumentListBuilder args) {
        if (this.forks > 0) {
            args.add("-f").add((Object)this.forks);
        }
        return args;
    }

    public T setExtraVars(List<ExtraVar> extraVars) {
        this.extraVars = extraVars;
        return (T)this;
    }

    public ArgumentListBuilder appendExtraVars(ArgumentListBuilder args) {
        if (this.extraVars != null && !this.extraVars.isEmpty()) {
            for (ExtraVar var : this.extraVars) {
                if (var.getSecretValue() == null) {
                    this.listener.getLogger().println("[WARN] Omitting extra var " + var.getKey() + ": check value is a supported type.");
                    continue;
                }
                args.add("-e");
                String value = this.envVars.expand(var.getSecretValue().getPlainText());
                if (Pattern.compile("\\s").matcher(value).find()) {
                    value = Util.singleQuote((String)value);
                }
                StringBuilder sb = new StringBuilder();
                if (value.equals("true") || value.equals("false")) {
                    sb.append("{\"").append(this.envVars.expand(var.getKey())).append("\":").append(value).append("}");
                } else {
                    sb.append(this.envVars.expand(var.getKey())).append("=").append(value);
                }
                if (var.isHidden()) {
                    args.addMasked(sb.toString());
                    continue;
                }
                args.add(sb.toString());
            }
        }
        return args;
    }

    public T setAdditionalParameters(String additionalParameters) {
        this.additionalParameters = additionalParameters;
        return (T)this;
    }

    public ArgumentListBuilder appendAdditionalParameters(ArgumentListBuilder args) {
        args.addTokenized(this.envVars.expand(this.additionalParameters));
        return args;
    }

    public T setBecome(boolean become, String becomeUser) {
        this.become = become;
        this.becomeUser = becomeUser;
        return (T)this;
    }

    protected ArgumentListBuilder appendBecome(ArgumentListBuilder args) {
        if (this.become) {
            args.add("-b");
            this.addOptionAndValue(args, "--become-user", this.becomeUser);
        }
        return args;
    }

    public T setSudo(boolean sudo, String sudoUser) {
        this.sudo = sudo;
        this.sudoUser = sudoUser;
        return (T)this;
    }

    protected ArgumentListBuilder appendSudo(ArgumentListBuilder args) {
        if (this.sudo) {
            args.add("-s");
            this.addOptionAndValue(args, "-U", this.sudoUser);
        }
        return args;
    }

    protected void addOptionAndValue(ArgumentListBuilder args, String option, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String expandedValue = this.envVars.expand(value);
            if (StringUtils.isNotBlank((CharSequence)expandedValue)) {
                args.add(option).add(expandedValue);
            } else {
                this.listener.getLogger().println("[WARNING] parameter " + value + " is empty. Omitting option '" + option + "'.");
            }
        }
    }

    protected void addKeyValuePair(ArgumentListBuilder args, String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String expandedValue = this.envVars.expand(value);
            if (StringUtils.isNotBlank((CharSequence)expandedValue)) {
                args.addKeyValuePair("", key, expandedValue, false);
            } else {
                this.listener.getLogger().println("[WARNING] parameter " + value + " is empty. Omitting option '" + key + "'.");
            }
        }
    }

    public T setCredentials(StandardUsernameCredentials credentials) {
        this.credentials = credentials;
        return (T)this;
    }

    public T setCredentials(StandardUsernameCredentials credentials, boolean copyCredentialsInWorkspace) {
        this.copyCredentialsInWorkspace = copyCredentialsInWorkspace;
        return this.setCredentials(credentials);
    }

    public T setVaultCredentials(StandardCredentials vaultCredentials) {
        this.vaultCredentials = vaultCredentials;
        return (T)this;
    }

    public T setVaultTmpPath(FilePath vaultTmpPath) {
        this.vaultTmpPath = vaultTmpPath;
        return (T)this;
    }

    protected ArgumentListBuilder prependPasswordCredentials(ArgumentListBuilder args) {
        if (this.credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials passwordCredentials = (UsernamePasswordCredentials)this.credentials;
            args.add("sshpass").addMasked("-p" + Secret.toString((Secret)passwordCredentials.getPassword()));
        }
        return args;
    }

    protected ArgumentListBuilder appendCredentials(ArgumentListBuilder args) throws IOException, InterruptedException {
        if (this.credentials instanceof SSHUserPrivateKey) {
            FilePath tmpPath = this.vaultTmpPath != null ? this.vaultTmpPath : this.ws;
            SSHUserPrivateKey privateKeyCredentials = (SSHUserPrivateKey)this.credentials;
            this.key = Utils.createSshKeyFile(this.key, tmpPath, privateKeyCredentials, this.copyCredentialsInWorkspace);
            args.add("--private-key").add(this.key.getRemote().replace("%", "%%"));
            args.add("-u").add(privateKeyCredentials.getUsername());
            if (privateKeyCredentials.getPassphrase() != null) {
                this.script = Utils.createSshAskPassFile(this.script, tmpPath, privateKeyCredentials, this.copyCredentialsInWorkspace);
                this.environment.put("SSH_ASKPASS", this.script.getRemote());
                if (!this.environment.containsKey("DISPLAY")) {
                    this.environment.put("DISPLAY", ":123.456");
                }
            }
        } else if (this.credentials instanceof UsernamePasswordCredentials) {
            args.add("-u").add(this.credentials.getUsername());
            args.add("-k");
        }
        return args;
    }

    protected ArgumentListBuilder appendVaultPasswordFile(ArgumentListBuilder args) throws IOException, InterruptedException {
        if (this.vaultCredentials != null) {
            FilePath tmpPath;
            FilePath filePath = tmpPath = this.vaultTmpPath != null ? this.vaultTmpPath : this.ws;
            if (this.vaultCredentials instanceof FileCredentials) {
                FileCredentials secretFile = (FileCredentials)this.vaultCredentials;
                this.vaultPassword = Utils.createVaultPasswordFile(this.vaultPassword, tmpPath, secretFile);
                args.add("--vault-password-file").add(this.vaultPassword.getRemote().replace("%", "%%"));
            } else if (this.vaultCredentials instanceof StringCredentials) {
                StringCredentials secretText = (StringCredentials)this.vaultCredentials;
                this.vaultPassword = Utils.createVaultPasswordFile(this.vaultPassword, tmpPath, secretText);
                args.add("--vault-password-file").add(this.vaultPassword.getRemote().replace("%", "%%"));
            }
        }
        return args;
    }

    public T setUnbufferedOutput(boolean unbufferedOutput) {
        if (unbufferedOutput) {
            this.environment.put("PYTHONUNBUFFERED", "1");
        }
        return (T)this;
    }

    public T setColorizedOutput(boolean colorizedOutput) {
        if (colorizedOutput) {
            this.environment.put("ANSIBLE_FORCE_COLOR", "true");
        }
        return (T)this;
    }

    public T setDisableHostKeyCheck(boolean disableHostKeyChecking) {
        if (disableHostKeyChecking) {
            this.environment.put("ANSIBLE_HOST_KEY_CHECKING", "False");
        }
        return (T)this;
    }

    protected abstract ArgumentListBuilder buildCommandLine() throws InterruptedException, AnsibleInvocationException, IOException;

    public boolean execute(CLIRunner runner) throws IOException, InterruptedException, AnsibleInvocationException {
        try {
            boolean bl = runner.execute(this.buildCommandLine(), this.environment);
            return bl;
        }
        finally {
            if (this.inventory != null) {
                this.inventory.tearDown(this.listener);
            }
            Utils.deleteTempFile(this.key, this.listener);
            Utils.deleteTempFile(this.script, this.listener);
            Utils.deleteTempFile(this.vaultPassword, this.listener);
        }
    }
}

