/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.androidsigning;

import com.google.inject.Inject;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.androidsigning.Messages;
import org.jenkinsci.plugins.androidsigning.SignApksBuilder;
import org.jenkinsci.plugins.androidsigning.SignedApkMappingStrategy;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SignApksStep
extends AbstractStepImpl {
    @CheckForNull
    private String keyStoreId;
    @CheckForNull
    private String keyAlias;
    @CheckForNull
    private String apksToSign;
    private SignedApkMappingStrategy signedApkMapping;
    private String androidHome;
    private String zipalignPath;
    private boolean skipZipalign = false;
    private boolean archiveSignedApks = true;
    private boolean archiveUnsignedApks = false;

    @DataBoundConstructor
    public SignApksStep() {
    }

    @DataBoundSetter
    public void setKeyStoreId(String x) {
        this.keyStoreId = x;
    }

    @DataBoundSetter
    public void setKeyAlias(String x) {
        this.keyAlias = x;
    }

    @DataBoundSetter
    public void setApksToSign(String x) {
        this.apksToSign = x;
    }

    @DataBoundSetter
    public void setSignedApkMapping(SignedApkMappingStrategy x) {
        this.signedApkMapping = x;
    }

    @DataBoundSetter
    public void setSkipZipalign(boolean x) {
        this.skipZipalign = x;
    }

    @DataBoundSetter
    public void setArchiveSignedApks(boolean x) {
        this.archiveSignedApks = x;
    }

    @DataBoundSetter
    public void setArchiveUnsignedApks(boolean x) {
        this.archiveUnsignedApks = x;
    }

    @DataBoundSetter
    public void setAndroidHome(String x) {
        this.androidHome = x;
    }

    @DataBoundSetter
    public void setZipalignPath(String x) {
        this.zipalignPath = x;
    }

    public String getKeyStoreId() {
        return this.keyStoreId;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public String getApksToSign() {
        return this.apksToSign;
    }

    public SignedApkMappingStrategy getSignedApkMapping() {
        return this.signedApkMapping;
    }

    public boolean getSkipZipalign() {
        return this.skipZipalign;
    }

    public boolean getArchiveSignedApks() {
        return this.archiveSignedApks;
    }

    public boolean getArchiveUnsignedApks() {
        return this.archiveUnsignedApks;
    }

    public String getAndroidHome() {
        return this.androidHome;
    }

    public String getZipalignPath() {
        return this.zipalignPath;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(SignApksStepExecution.class);
        }

        public String getFunctionName() {
            return "signAndroidApks";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.builderDisplayName();
        }
    }

    private static class SignApksStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient SignApksStep step;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient FilePath workspace;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient EnvVars env;

        private SignApksStepExecution() {
        }

        protected Void run() throws Exception {
            String androidHome = this.step.getAndroidHome();
            String zipalignPath = this.step.getZipalignPath();
            if (StringUtils.isEmpty((String)androidHome) && StringUtils.isEmpty((String)zipalignPath)) {
                if (StringUtils.isEmpty((String)androidHome)) {
                    androidHome = (String)this.env.get((Object)"ANDROID_HOME");
                }
                if (StringUtils.isEmpty((String)zipalignPath)) {
                    zipalignPath = (String)this.env.get((Object)"ANDROID_ZIPALIGN");
                }
            }
            SignApksBuilder builder = new SignApksBuilder();
            builder.setKeyStoreId(this.step.getKeyStoreId());
            builder.setKeyAlias(this.step.getKeyAlias());
            builder.setApksToSign(this.step.getApksToSign());
            builder.setSignedApkMapping(this.step.getSignedApkMapping());
            builder.setSkipZipalign(this.step.getSkipZipalign());
            builder.setArchiveSignedApks(this.step.getArchiveSignedApks());
            builder.setArchiveUnsignedApks(this.step.getArchiveUnsignedApks());
            builder.setAndroidHome(androidHome);
            builder.setZipalignPath(zipalignPath);
            builder.perform(this.build, this.workspace, this.launcher, this.listener);
            return null;
        }
    }
}

