/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.androidsigning;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.util.ArgumentListBuilder;
import hudson.util.VersionNumber;
import java.io.PrintStream;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

class ZipalignTool {
    static final String ENV_ANDROID_HOME = "ANDROID_HOME";
    static final String ENV_ZIPALIGN_PATH = "ANDROID_ZIPALIGN";
    private final EnvVars env;
    private final FilePath workspace;
    private final PrintStream logger;
    private final String overrideAndroidHome;
    private final String overrideZipalignPath;
    private FilePath zipalign;

    private static FilePath findFromEnv(EnvVars env, FilePath workspace, PrintStream logger) throws AbortException {
        String zipalignPath = (String)env.get((Object)ENV_ZIPALIGN_PATH);
        if (!StringUtils.isEmpty((String)zipalignPath)) {
            zipalignPath = env.expand(zipalignPath);
            logger.printf("[SignApksBuilder] found zipalign path in env %s=%s%n", ENV_ZIPALIGN_PATH, zipalignPath);
            return new FilePath(workspace.getChannel(), zipalignPath);
        }
        String androidHome = (String)env.get((Object)ENV_ANDROID_HOME);
        if (StringUtils.isEmpty((String)androidHome)) {
            throw new AbortException("failed to find zipalign: no environment variable ANDROID_ZIPALIGN or ANDROID_HOME");
        }
        androidHome = env.expand(androidHome);
        logger.printf("[SignApksBuilder] searching environment variable %s=%s for zipalign...%n", ENV_ANDROID_HOME, androidHome);
        return ZipalignTool.findInAndroidHome(androidHome, workspace, logger);
    }

    private static FilePath findInAndroidHome(String androidHome, FilePath workspace, PrintStream logger) throws AbortException {
        List versionDirs;
        FilePath buildTools = workspace.child(androidHome).child("build-tools");
        try {
            versionDirs = buildTools.listDirectories();
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            throw new AbortException(String.format("failed to find zipalign: error listing build-tools versions in %s: %s", buildTools.getRemote(), e.getLocalizedMessage()));
        }
        if (versionDirs == null || versionDirs.isEmpty()) {
            throw new AbortException("failed to find zipalign: no build-tools directory in Android home path " + androidHome);
        }
        TreeMap<VersionNumber, FilePath> versions = new TreeMap<VersionNumber, FilePath>();
        for (FilePath versionDir : versionDirs) {
            String versionName = versionDir.getName();
            VersionNumber version = new VersionNumber(versionName);
            versions.put(version, versionDir);
        }
        if (versions.isEmpty()) {
            throw new AbortException("failed to find zipalign: no build-tools versions in Android home path " + buildTools);
        }
        VersionNumber latest = (VersionNumber)versions.lastKey();
        buildTools = (FilePath)versions.get(latest);
        FilePath zipalign = buildTools.child("zipalign");
        logger.printf("[SignApksBuilder] found zipalign in Android SDK's latest build tools: %s%n", zipalign.getRemote());
        return zipalign;
    }

    private static FilePath ensureZipalignExists(FilePath zipalign, PrintStream logger) throws AbortException {
        try {
            if (zipalign.exists()) {
                return zipalign;
            }
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            throw new AbortException(e.getMessage());
        }
        try {
            zipalign = zipalign.getParent().child("zipalign.exe");
            if (zipalign.exists()) {
                return zipalign;
            }
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            throw new AbortException(e.getMessage());
        }
        throw new AbortException("failed to find zipalign: no zipalign/zipalign.exe in latest build-tools path " + zipalign.getParent().getRemote());
    }

    ZipalignTool(@Nonnull EnvVars env, @Nonnull FilePath workspace, @Nonnull PrintStream logger, @Nullable String overrideAndroidHome, @Nullable String overrideZipalignPath) {
        this.env = env;
        this.workspace = workspace;
        this.logger = logger;
        this.overrideAndroidHome = overrideAndroidHome;
        this.overrideZipalignPath = overrideZipalignPath;
    }

    ArgumentListBuilder commandFor(String unsignedApk, String outputApk) throws AbortException {
        if (this.zipalign == null) {
            if (!StringUtils.isEmpty((String)this.overrideZipalignPath)) {
                this.logger.printf("[SignApksBuilder] zipalign path explicitly set to %s%n", this.overrideZipalignPath);
                this.zipalign = this.workspace.child(this.env.expand(this.overrideZipalignPath));
            } else if (!StringUtils.isEmpty((String)this.overrideAndroidHome)) {
                this.logger.printf("[SignApksBuilder] zipalign %s explicitly set to %s%n", ENV_ANDROID_HOME, this.overrideAndroidHome);
                String expandedAndroidHome = this.env.expand(this.overrideAndroidHome);
                this.zipalign = ZipalignTool.findInAndroidHome(expandedAndroidHome, this.workspace, this.logger);
            } else {
                this.zipalign = ZipalignTool.findFromEnv(this.env, this.workspace, this.logger);
            }
            this.zipalign = ZipalignTool.ensureZipalignExists(this.zipalign, this.logger);
        }
        return new ArgumentListBuilder().add(this.zipalign.getRemote()).add("-f").add("-p").add("4").add(unsignedApk).add(outputApk);
    }
}

