/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.androidsigning;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.util.ArgumentListBuilder;
import hudson.util.VersionNumber;
import java.io.PrintStream;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

class ZipalignTool {
    private final EnvVars env;
    private final FilePath workspace;
    private final PrintStream logger;
    private FilePath zipalign;

    private static FilePath findFromEnv(EnvVars env, FilePath workspace, PrintStream logger) throws AbortException {
        List versionDirs;
        String zipalignPath = (String)env.get((Object)"ANDROID_ZIPALIGN");
        if (!StringUtils.isEmpty((String)zipalignPath)) {
            zipalignPath = env.expand(zipalignPath);
            logger.printf("[SignApksBuilder] found zipalign path in env ANDROID_ZIPALIGN=%s%n", zipalignPath);
            return new FilePath(workspace.getChannel(), zipalignPath);
        }
        String androidHome = (String)env.get((Object)"ANDROID_HOME");
        if (StringUtils.isEmpty((String)androidHome)) {
            throw new AbortException("failed to find zipalign: no environment variable ANDROID_ZIPALIGN or ANDROID_HOME");
        }
        androidHome = env.expand(androidHome);
        FilePath buildTools = new FilePath(workspace.getChannel(), androidHome).child("build-tools");
        try {
            versionDirs = buildTools.listDirectories();
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            throw new AbortException(String.format("failed to find zipalign: error listing build-tools versions in %s: %s", buildTools.getRemote(), e.getLocalizedMessage()));
        }
        if (versionDirs == null || versionDirs.isEmpty()) {
            throw new AbortException("failed to find zipalign: no build-tools directory in ANDROID_HOME path " + androidHome);
        }
        TreeMap<VersionNumber, FilePath> versions = new TreeMap<VersionNumber, FilePath>();
        for (FilePath versionDir : versionDirs) {
            String versionName = versionDir.getName();
            VersionNumber version = new VersionNumber(versionName);
            versions.put(version, versionDir);
        }
        if (versions.isEmpty()) {
            throw new AbortException("failed to find zipalign: no build-tools versions in ANDROID_HOME path " + buildTools);
        }
        VersionNumber latest = (VersionNumber)versions.lastKey();
        buildTools = (FilePath)versions.get(latest);
        FilePath zipalign = buildTools.child("zipalign");
        try {
            if (!zipalign.exists()) {
                zipalign = buildTools.child("zipalign.exe");
            }
            if (!zipalign.exists()) {
                throw new AbortException("failed to find zipalign: no zipalign/zipalign.exe in latest build-tools path " + zipalign.getParent().getRemote());
            }
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            throw new AbortException(String.format("failed to find zipalign: error listing build-tools versions in %s: %s", buildTools.getRemote(), e.getLocalizedMessage()));
        }
        logger.printf("[SignApksBuilder] found zipalign in Android SDK's latest build tools: %s%n", zipalign.getRemote());
        return zipalign;
    }

    ZipalignTool(@Nonnull EnvVars env, @Nonnull FilePath workspace, @Nonnull PrintStream logger, @Nullable String overrideZipalignPath) {
        this.env = env;
        this.workspace = workspace;
        this.logger = logger;
        if (StringUtils.isNotEmpty((String)overrideZipalignPath)) {
            overrideZipalignPath = env.expand(overrideZipalignPath);
            this.zipalign = new FilePath(workspace.getChannel(), overrideZipalignPath);
        }
    }

    ArgumentListBuilder commandFor(String unsignedApk, String outputApk) throws AbortException {
        if (this.zipalign == null) {
            this.zipalign = ZipalignTool.findFromEnv(this.env, this.workspace, this.logger);
        }
        return new ArgumentListBuilder().add(this.zipalign.getRemote()).add("-f").add("-p").add("4").add(unsignedApk).add(outputApk);
    }
}

