/*
 * Decompiled with CFR 0.152.
 */
package com.datalex.jdkparameter;

import com.datalex.jdkparameter.JavaParameterBuildWrapper;
import hudson.model.AbstractBuild;
import hudson.model.JDK;
import hudson.model.ParameterValue;
import hudson.tasks.BuildWrapper;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class JavaParameterValue
extends ParameterValue {
    private static final Logger LOGGER = Logger.getLogger(JavaParameterValue.class.getName());
    private String selectedJDK;

    @DataBoundConstructor
    public JavaParameterValue(String name, String description, String selectedJDK) {
        super(name, description);
        this.selectedJDK = selectedJDK;
    }

    public String getSelectedJDK() {
        return this.selectedJDK;
    }

    public void setSelectedJDK(String selectedJDK) {
        this.selectedJDK = selectedJDK;
    }

    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        JDK selected = null;
        String originalJDK = null;
        boolean jdkIsAvailable = false;
        selected = new JDK("(Default)", null);
        for (JDK jdk : Jenkins.getInstance().getJDKs()) {
            if (!jdk.getName().equalsIgnoreCase(this.selectedJDK)) continue;
            selected = jdk;
            jdkIsAvailable = true;
            break;
        }
        if (this.selectedJDK.equals("(Default)")) {
            jdkIsAvailable = true;
        }
        try {
            originalJDK = build.getProject().getJDK() == null ? "(Default)" : build.getProject().getJDK().getName();
            build.getProject().setJDK(selected);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "[JDK Parameter]: Could not set the JDK", e);
        }
        JavaParameterBuildWrapper wrapper = new JavaParameterBuildWrapper();
        wrapper.setOriginalJDK(originalJDK);
        wrapper.setJdkIsAvailable(jdkIsAvailable);
        return wrapper;
    }
}

