/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.credentials;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.domains.Domain;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.Permission;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.conjur.jenkins.api.ConjurAPI;
import org.conjur.jenkins.credentials.ConjurCredentialProvider;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconType;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.ExportedBean;
import org.springframework.security.core.Authentication;

public class ConjurCredentialStore
extends CredentialsStore {
    private static final String DISPLAY_NAME = "Conjur Credential Storage";
    private static final Logger LOGGER = Logger.getLogger(ConjurCredentialStore.class.getName());
    private static ConcurrentHashMap<String, ConjurCredentialStore> allStores = new ConcurrentHashMap();
    private final ConjurCredentialProvider provider;
    private final ModelObject context;
    private final ConjurCredentialStoreAction action;

    public ConjurCredentialStore(ConjurCredentialProvider provider, ModelObject context) {
        super(ConjurCredentialProvider.class);
        this.provider = provider;
        this.context = context;
        this.action = new ConjurCredentialStoreAction(this, context);
    }

    public static void putCredentialStore(String key, ConjurCredentialStore c) {
        allStores.put(key, c);
    }

    public static ConjurCredentialStore getCredentialStore(String key) {
        return allStores.get(key);
    }

    public static boolean isStoreContainsKey(String key) {
        return allStores.containsKey(key);
    }

    @NonNull
    public ModelObject getContext() {
        return this.context;
    }

    public boolean hasPermission2(@NonNull Authentication authentication, @NonNull Permission permission) {
        LOGGER.log(Level.FINEST, "Conjur CredentialStore hasPermission() ");
        boolean isAdmin = Jenkins.get().getACL().hasPermission2(authentication, Jenkins.ADMINISTER);
        boolean hasCredentialsView = Jenkins.get().getACL().hasPermission2(authentication, CredentialsProvider.VIEW);
        LOGGER.log(Level.FINEST, String.format("Checking permissions for the user: %s admin %s credview %s", authentication.getName(), isAdmin ? "yes" : "no", hasCredentialsView ? "yes" : "no"));
        if (!CredentialsProvider.VIEW.equals((Object)permission)) {
            return false;
        }
        if (!hasCredentialsView && !isAdmin) {
            Item currentItem;
            StaplerRequest currentRequest = Stapler.getCurrentRequest();
            Item item = currentItem = currentRequest != null ? (Item)currentRequest.findAncestorObject(Item.class) : null;
            if (currentItem == null) {
                LOGGER.log(Level.WARNING, "Unable to determine the current item for permission check ");
                return false;
            }
            LOGGER.log(Level.FINEST, String.format("Current item: %s", currentItem.getFullName()));
            boolean hasItemViewPermission = currentItem.getACL().hasPermission2(authentication, CredentialsProvider.VIEW);
            LOGGER.log(Level.FINEST, String.format("Non-admin user for the current Jenkins item: %s - %s", currentItem.getFullName(), hasItemViewPermission ? "yes" : "no"));
            return hasItemViewPermission;
        }
        return isAdmin || hasCredentialsView;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @NonNull
    public List<Credentials> getCredentials(@NonNull Domain domain) {
        int pos;
        Item contextItem;
        Item currentContext;
        Authentication authentication = Jenkins.getAuthentication2();
        if (!this.hasPermission2(authentication, CredentialsProvider.VIEW)) {
            LOGGER.log(Level.FINEST, String.format("User: %s does not have permission to view credentials.", authentication.getName()));
            return Collections.emptyList();
        }
        StaplerRequest currentStaplerRequest = Stapler.getCurrentRequest();
        Item item = currentContext = currentStaplerRequest != null ? (Item)currentStaplerRequest.findAncestorObject(Item.class) : null;
        if (this.context instanceof Hudson || currentContext == null) {
            LOGGER.log(Level.FINEST, "ConjurCredentialStore: Global credentials found!");
            return this.provider.getCredentials(Credentials.class, (ModelObject)Jenkins.get());
        }
        String storePath = null;
        if (this.context instanceof Item) {
            contextItem = (Item)this.context;
            storePath = contextItem.getFullName();
        } else if (this.context instanceof ItemGroup) {
            contextItem = (ItemGroup)this.context;
            storePath = contextItem.getFullName();
        }
        if (storePath != null && (pos = currentContext.getFullName().indexOf(storePath)) != 0) {
            LOGGER.log(Level.FINEST, "Cannot deliver credentials from path to which you don't have access");
            return Collections.emptyList();
        }
        if (this.getContext() != currentContext) {
            if (ConjurAPI.isInheritanceOn((ModelObject)currentContext)) {
                if (!(currentContext instanceof Hudson)) {
                    ItemGroup currFolder = currentContext.getParent();
                    while (currFolder instanceof AbstractFolder) {
                        Item folderAsItem = (Item)currFolder;
                        LOGGER.log(Level.FINEST, String.format("ConjurCredentialStore getCredentials, context:  current folder name: %s currentContext.getFullDisplayName(): %s g.getFullDisplayName(): %s  item: %s", this.context.getDisplayName(), currFolder.getFullName(), currentContext.getFullName(), currFolder.getFullDisplayName(), folderAsItem.getFullName()));
                        LOGGER.log(Level.FINEST, String.format("storepath %s actfolder %s", storePath, folderAsItem.getFullName()));
                        boolean inheritanceIsOn = ConjurAPI.isInheritanceOn((ModelObject)currFolder);
                        if (!inheritanceIsOn) {
                            LOGGER.log(Level.FINEST, "Cannot deliver credentials from path to which you don't have access or inhertiance is: off");
                            return Collections.emptyList();
                        }
                        currFolder = ((AbstractFolder)AbstractFolder.class.cast(currFolder)).getParent();
                    }
                }
            } else {
                return Collections.emptyList();
            }
        }
        return this.provider.getCredentials(Credentials.class, this.getContext());
    }

    public boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) {
        throw new UnsupportedOperationException("Jenkins may not add credentials to Conjur");
    }

    public boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) {
        throw new UnsupportedOperationException("Jenkins may not remove credentials from Conjur");
    }

    public boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) {
        throw new UnsupportedOperationException("Jenkins may not update credentials in Conjur");
    }

    @Nullable
    public CredentialsStoreAction getStoreAction() {
        return this.action;
    }

    @ExportedBean
    public static class ConjurCredentialStoreAction
    extends CredentialsStoreAction {
        private static final String DISPLAY_NAME = "Conjur Credential Store";
        private static final String ICON_CLASS = "icon-conjur-credentials-store";
        private final ConjurCredentialStore store;
        private final ModelObject context;

        protected ConjurCredentialStoreAction(ConjurCredentialStore store, ModelObject context) {
            this.store = store;
            this.context = context;
            this.addIcons();
        }

        private void addIcons() {
            IconSet.icons.addIcon(new Icon("icon-conjur-credentials-store icon-sm", "conjur-credentials/images/conjur-credential-store-sm.png", "width: 16px; height: 16px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-conjur-credentials-store icon-md", "conjur-credentials/images/conjur-credential-store-md.png", "width: 24px; height: 24px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-conjur-credentials-store icon-lg", "conjur-credentials/images/conjur-credential-store-lg.png", "width: 32px; height: 32px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-conjur-credentials-store icon-xlg", "conjur-credentials/images/conjur-credential-store-xlg.png", "width: 48px; height: 48px;", IconType.PLUGIN));
        }

        @NonNull
        public ConjurCredentialStore getStore() {
            return this.store;
        }

        public String getIconFileName() {
            return this.isVisible() ? "/plugin/conjur-credentials/images/conjur-credential-store-lg.png" : null;
        }

        public String getIconClassName() {
            return this.isVisible() ? ICON_CLASS : null;
        }

        public String getDisplayName() {
            return DISPLAY_NAME;
        }
    }
}

