/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.conjursecrets;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsSnapshotTaker;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.conjur.jenkins.api.ConjurAPI;
import org.conjur.jenkins.api.ConjurAPIUtils;
import org.conjur.jenkins.conjursecrets.ConjurSecretStringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ConjurSecretStringCredentialsImpl
extends BaseStandardCredentials
implements ConjurSecretStringCredentials {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ConjurSecretStringCredentialsImpl.class.getName());
    private String variableId;
    private transient ModelObject context;
    boolean storedInConjurStorage = false;
    private transient ModelObject inheritedObjectContext;

    @Override
    public String getDisplayName() {
        return "ConjurSecretString:" + this.variableId;
    }

    @DataBoundConstructor
    public ConjurSecretStringCredentialsImpl(CredentialsScope scope, String id, String variableId, String description) {
        super(scope, id, description);
        this.variableId = variableId;
        LOGGER.log(Level.FINEST, "ConjurSecretStringCredentialsImpl");
    }

    static Secret secretFromString(String secretString) {
        return Secret.fromString((String)secretString);
    }

    @DataBoundSetter
    public void setVariableId(String variableId) {
        this.variableId = variableId;
    }

    public String getVariableId() {
        return this.variableId;
    }

    @Override
    public void setContext(ModelObject context) {
        this.context = context;
    }

    @Override
    public ModelObject getContext() {
        return this.context;
    }

    @Override
    public void setInheritedContext(ModelObject context) {
        this.inheritedObjectContext = context;
    }

    @Override
    public ModelObject getInheritedContext() {
        return this.inheritedObjectContext;
    }

    @Override
    public void setStoredInConjurStorage(boolean storedInConjurStorage) {
        this.storedInConjurStorage = storedInConjurStorage;
    }

    @Override
    public boolean storedInConjurStorage() {
        return this.storedInConjurStorage;
    }

    @Override
    public Secret getSecret() {
        Secret retSecret = this.storedInConjurStorage ? ConjurAPI.getSecretFromConjur(this.context, this.inheritedObjectContext, this.variableId) : ConjurAPI.getSecretFromConjurWithInheritance(this.context, this, this.variableId);
        return retSecret;
    }

    @Override
    public String getNameTag() {
        return "";
    }

    @Extension
    public static class SnapshotTaker
    extends CredentialsSnapshotTaker<ConjurSecretStringCredentialsImpl> {
        public Class<ConjurSecretStringCredentialsImpl> type() {
            return ConjurSecretStringCredentialsImpl.class;
        }

        public ConjurSecretStringCredentialsImpl snapshot(ConjurSecretStringCredentialsImpl credentials) {
            return new SelfContained(credentials);
        }
    }

    static class SelfContained
    extends ConjurSecretStringCredentialsImpl {
        private final Secret secret;

        public SelfContained(ConjurSecretStringCredentialsImpl base) {
            super(base.getScope(), base.getId(), base.getVariableId(), base.getDescription());
            this.secret = base.getSecret();
        }

        @Override
        @NonNull
        public Secret getSecret() {
            return this.secret;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        private static final String DISPLAY_NAME = "Conjur Secret String Credential";

        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public FormValidation doTestConnection(@AncestorInPath ItemGroup<Item> context, @QueryParameter(value="credentialID") String credentialID, @QueryParameter(value="variableId") String variableId) {
            if (variableId == null || variableId.isEmpty()) {
                return FormValidation.error((String)"FAILED variableId field is required");
            }
            ConjurSecretStringCredentialsImpl credential = new ConjurSecretStringCredentialsImpl(CredentialsScope.GLOBAL, credentialID, variableId, "desc");
            return ConjurAPIUtils.validateCredential(context, credential);
        }
    }
}

