/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.conjursecrets;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.Secret;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.conjur.jenkins.conjursecrets.ConjurSecretDockerCertCredentials;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ConjurSecretDockerCertCredentialsBinding
extends MultiBinding<ConjurSecretDockerCertCredentials> {
    private String clientKeyVariable;
    private String clientCertVariable;
    private String caCertificateVariable;

    @DataBoundConstructor
    public ConjurSecretDockerCertCredentialsBinding(String credentialsId) {
        super(credentialsId);
    }

    public MultiBinding.MultiEnvironment bind(Run<?, ?> build, FilePath workSpace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        HashMap<String, String> m = new HashMap<String, String>();
        ConjurSecretDockerCertCredentials credentials = (ConjurSecretDockerCertCredentials)this.getCredentials(build);
        if (credentials != null) {
            credentials.setContext((ModelObject)build);
            Secret secret = credentials.getClientKeySecret();
            if (secret != null) {
                m.put(this.clientKeyVariable, secret.getPlainText());
            }
            m.put(this.clientCertVariable, credentials.getClientCertificate());
            m.put(this.caCertificateVariable, credentials.getServerCaCertificate());
        }
        return new MultiBinding.MultiEnvironment(m);
    }

    protected Class<ConjurSecretDockerCertCredentials> type() {
        return ConjurSecretDockerCertCredentials.class;
    }

    public String getClientKeyVariable() {
        return this.clientKeyVariable;
    }

    @DataBoundSetter
    public void setClientKeyVariable(String clientKeyVariable) {
        this.clientKeyVariable = clientKeyVariable;
    }

    public String getClientCertVariable() {
        return this.clientCertVariable;
    }

    @DataBoundSetter
    public void setClientCertVariable(String clientCertVariable) {
        this.clientCertVariable = clientCertVariable;
    }

    public String getCaCertificateVariable() {
        return this.caCertificateVariable;
    }

    @DataBoundSetter
    public void setCaCertificateVariable(String caCertificateVariable) {
        this.caCertificateVariable = caCertificateVariable;
    }

    public Set<String> variables() {
        return new HashSet<String>(Arrays.asList(this.clientKeyVariable, this.clientCertVariable, this.caCertificateVariable));
    }

    @Symbol(value={"conjurSecretDockerClientCert"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<ConjurSecretDockerCertCredentials> {
        private static final String DISPLAY_NAME = "Conjur Secret Docker Certificate credentials";

        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public boolean requiresWorkspace() {
            return false;
        }

        protected Class<ConjurSecretDockerCertCredentials> type() {
            return ConjurSecretDockerCertCredentials.class;
        }
    }
}

