/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.configuration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TelemetryConfiguration {
    private static final Logger LOGGER = Logger.getLogger(TelemetryConfiguration.class.getName());
    private static final String DEFAULT_INTEGRATION_NAME = "Jenkins Plugin";
    private static final String DEFAULT_INTEGRATION_TYPE = "cybr-secretsmanager-jenkins";
    private static final String DEFAULT_VENDOR_NAME = "Jenkins";
    private static final String DEFAULT_VERSION = "unknown";
    private static String finalHeader = null;
    private static String cachedPluginVersion = null;

    public static String getTelemetryHeader() {
        if (finalHeader == null) {
            finalHeader = TelemetryConfiguration.buildTelemetryHeader();
        }
        return finalHeader;
    }

    public static String buildTelemetryHeader() {
        String integrationName = DEFAULT_INTEGRATION_NAME;
        String integrationType = DEFAULT_INTEGRATION_TYPE;
        String integrationVersion = TelemetryConfiguration.getPluginVersion();
        String vendorName = DEFAULT_VENDOR_NAME;
        String telemetryData = String.format("in=%s&it=%s&iv=%s&vn=%s", integrationName, integrationType, integrationVersion, vendorName);
        return Base64.getUrlEncoder().encodeToString(telemetryData.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPluginVersion() {
        if (cachedPluginVersion != null) {
            return cachedPluginVersion;
        }
        Path changelogPath = Paths.get("CHANGELOG.md", new String[0]);
        Pattern versionPattern = Pattern.compile("## \\[([\\d]+(?:\\.[\\d]+)*)\\]");
        try (InputStream inputStream = Files.newInputStream(changelogPath, new OpenOption[0]);
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = versionPattern.matcher(line);
                if (!matcher.find()) continue;
                cachedPluginVersion = matcher.group(1);
                LOGGER.info("Found version in CHANGELOG.md: " + cachedPluginVersion);
                String string = cachedPluginVersion;
                return string;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error reading CHANGELOG.md from the JAR.", e);
        }
        cachedPluginVersion = DEFAULT_VERSION;
        return cachedPluginVersion;
    }
}

