/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.authenticator;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainCredentials;
import hudson.model.ModelObject;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.conjur.jenkins.api.ConjurAPI;
import org.conjur.jenkins.api.ConjurAPIUtils;
import org.conjur.jenkins.api.ConjurAuthnInfo;
import org.conjur.jenkins.authenticator.AbstractAuthenticator;
import org.conjur.jenkins.configuration.ConjurConfiguration;
import org.conjur.jenkins.exceptions.AuthenticationConjurException;

public class ConjurAPIKeyAuthenticator
extends AbstractAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(ConjurAPIKeyAuthenticator.class.getName());

    @Override
    public String getName() {
        return "APIKey";
    }

    @Override
    public byte[] getAuthorizationToken(ConjurAuthnInfo conjurAuthn, ModelObject context) throws IOException {
        byte[] resultingToken = null;
        LOGGER.log(Level.FINEST, String.format("getAuthorizationToken: authnPath %s account %s conjurAuthn.applianceUrl %s", conjurAuthn.getAuthnPath(), conjurAuthn.getAccount(), conjurAuthn.getApplianceUrl()));
        Request request = null;
        if (conjurAuthn.getApiKey() != null && conjurAuthn.getLogin() != null) {
            String urlstring = String.format("%s/%s/%s/%s/authenticate", conjurAuthn.getApplianceUrl(), conjurAuthn.getAuthnPath(), conjurAuthn.getAccount(), URLEncoder.encode(conjurAuthn.getLogin(), "utf-8"));
            request = new Request.Builder().url(urlstring).post(RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (byte[])conjurAuthn.getApiKey())).build();
        }
        if (request != null) {
            OkHttpClient client = ConjurAPIUtils.getHttpClient(conjurAuthn.getConjurConfiguration());
            Response response = client.newCall(request).execute();
            ResponseBody body = response.body();
            if (body != null) {
                byte[] respMessage = body.string().getBytes(StandardCharsets.UTF_8);
                resultingToken = Base64.getEncoder().withoutPadding().encodeToString(respMessage).getBytes(StandardCharsets.US_ASCII);
                LOGGER.log(Level.FINEST, () -> String.format("Conjur Authenticate response %d - %s", response.code(), response.message()));
            }
            if (response.code() != 200) {
                if (response.code() == 401) {
                    throw new AuthenticationConjurException(response.code());
                }
                throw new IOException("[" + response.code() + "] - " + response.message());
            }
        } else {
            LOGGER.log(Level.SEVERE, "Cannot create http call. Authentication failed.");
        }
        return resultingToken;
    }

    @Override
    public void fillAuthnInfo(ConjurAuthnInfo conjurAuthn, ModelObject context) {
        UsernamePasswordCredentials credential;
        ConjurConfiguration configuration = ConjurAPI.getConfigurationFromContext(context);
        CredentialsMatcher matcher = CredentialsMatchers.instanceOf(UsernamePasswordCredentials.class);
        List globalCreds = DomainCredentials.getCredentials((Map)SystemCredentialsProvider.getInstance().getDomainCredentialsMap(), UsernamePasswordCredentials.class, Collections.emptyList(), (CredentialsMatcher)matcher);
        if (configuration.getCredentialID() != null && !configuration.getCredentialID().isEmpty() && (credential = (UsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)globalCreds, (CredentialsMatcher)CredentialsMatchers.withId((String)configuration.getCredentialID()))) != null) {
            conjurAuthn.setLogin(credential.getUsername());
            conjurAuthn.setApiKey(credential.getPassword().getPlainText().getBytes(StandardCharsets.US_ASCII));
        }
        LOGGER.log(Level.SEVERE, String.format("UsernamePasswordCredentials found %d for ID %s", globalCreds.size(), configuration.getCredentialID()));
    }
}

