/*
 * Decompiled with CFR 0.152.
 */
package net.plavcak.jenkins.plugins.scmskip;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import net.plavcak.jenkins.plugins.scmskip.SCMSkipMatcher;
import net.plavcak.jenkins.plugins.scmskip.SCMSkipTools;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

public class SCMSkipBuildStep
extends Builder
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger(SCMSkipBuildStep.class.getName());
    private SCMSkipMatcher skipMatcher;
    private boolean deleteBuild;
    private String skipPattern;

    public SCMSkipBuildStep(boolean deleteBuild, String skipPattern) {
        this.deleteBuild = deleteBuild;
        this.skipPattern = skipPattern;
        if (this.skipPattern == null) {
            this.skipPattern = ".*\\[ci skip\\].*";
        }
        this.skipMatcher = new SCMSkipMatcher(this.getSkipPattern());
    }

    @DataBoundConstructor
    public SCMSkipBuildStep() {
        this(false, null);
    }

    public boolean isDeleteBuild() {
        return this.deleteBuild;
    }

    @DataBoundSetter
    public void setDeleteBuild(boolean deleteBuild) {
        this.deleteBuild = deleteBuild;
    }

    public String getSkipPattern() {
        if (this.skipPattern == null) {
            return this.getDescriptor().getSkipPattern();
        }
        return this.skipPattern;
    }

    @DataBoundSetter
    public void setSkipPattern(String skipPattern) {
        this.skipPattern = skipPattern;
        this.skipMatcher.setPattern(this.skipPattern);
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull EnvVars env, @NonNull TaskListener listener) throws IOException, FlowInterruptedException {
        if (SCMSkipTools.inspectChangeSetAndCause(run, this.skipMatcher, listener)) {
            SCMSkipTools.tagRunForDeletion(run, this.deleteBuild);
            try {
                SCMSkipTools.stopBuild(run);
            }
            catch (AbortException | FlowInterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "SCM Skip Build Step", e);
            }
        } else {
            SCMSkipTools.tagRunForDeletion(run, false);
        }
    }

    public boolean requiresWorkspace() {
        return false;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"scmSkip"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String skipPattern = ".*\\[ci skip\\].*";

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return false;
        }

        @NonNull
        public String getDisplayName() {
            return "SCM Skip Step";
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) {
            req.bindJSON((Object)this, json.getJSONObject("scmSkip"));
            this.save();
            return true;
        }

        public String getSkipPattern() {
            return this.skipPattern;
        }

        @DataBoundSetter
        public void setSkipPattern(String skipPattern) {
            this.skipPattern = skipPattern;
        }
    }
}

