/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.extensible_choice_parameter;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Result;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.ChoiceListProvider;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.ExtensibleChoiceParameterDefinition;
import jp.ikedam.jenkins.plugins.extensible_choice_parameter.Messages;
import org.jvnet.localizer.Localizable;

public abstract class AddEditedChoiceListProvider
extends ChoiceListProvider {
    private static final long serialVersionUID = 2844637600583498205L;
    private WhenToAdd whenToAdd = null;

    public WhenToAdd getWhenToAdd() {
        return this.whenToAdd;
    }

    public boolean isAddEditedValue() {
        return this.getWhenToAdd() != null;
    }

    public AddEditedChoiceListProvider(boolean addEditedValue, WhenToAdd whenToAdd) {
        this.whenToAdd = addEditedValue ? whenToAdd : null;
    }

    @Override
    public void onBuildCompletedWithValue(AbstractBuild<?, ?> build, ExtensibleChoiceParameterDefinition def, String value) {
        if (this.getWhenToAdd() == null || !this.getWhenToAdd().contains(build.getResult())) {
            return;
        }
        if (this.getChoiceList().contains(value)) {
            return;
        }
        AbstractProject project = build.getProject();
        this.addEditedValue(project, def, value);
    }

    @Override
    public void onBuildTriggeredWithValue(AbstractProject<?, ?> job, ExtensibleChoiceParameterDefinition def, String value) {
        if (this.getWhenToAdd() != WhenToAdd.Triggered) {
            return;
        }
        if (this.getChoiceList().contains(value)) {
            return;
        }
        this.addEditedValue(job, def, value);
    }

    protected abstract void addEditedValue(AbstractProject<?, ?> var1, ExtensibleChoiceParameterDefinition var2, String var3);

    public static enum WhenToAdd {
        Triggered(Messages._AddEditedChoiceListProvider_WhenToAdd_Triggered(), new Result[0]),
        Completed(Messages._AddEditedChoiceListProvider_WhenToAdd_Completed(), Result.SUCCESS, Result.UNSTABLE, Result.FAILURE),
        CompletedStable(Messages._AddEditedChoiceListProvider_WhenToAdd_CompletedStable(), Result.SUCCESS),
        CompletedUnstable(Messages._AddEditedChoiceListProvider_WhenToAdd_CompletedUnstable(), Result.SUCCESS, Result.UNSTABLE);

        private Localizable name;
        private Result[] results;

        private WhenToAdd(Localizable name, Result ... results) {
            this.name = name;
            this.results = results;
        }

        public String toString() {
            return this.name.toString();
        }

        public boolean contains(Result result) {
            for (Result r : this.results) {
                if (r != result) continue;
                return true;
            }
            return false;
        }
    }
}

