/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.kohsuke.stapler.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@Mojo(name="i18n")
public class LocalizerMojo
extends AbstractMojo {
    @Parameter(defaultValue="${locale}", required=true)
    protected String locale;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    SAXParser parser;
    private static final Pattern RESOURCE_LITERAL_STRING = Pattern.compile("(\"%[^\"]+\")|('%[^']+')");

    public void execute() throws MojoExecutionException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            this.parser = spf.newSAXParser();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new Error(e);
        }
        for (Resource res : this.project.getResources()) {
            File dir = new File(res.getDirectory());
            this.processDirectory(dir);
        }
    }

    private void process(File file) throws MojoExecutionException {
        if (file.isDirectory()) {
            this.processDirectory(file);
        } else if (file.getName().endsWith(".jelly")) {
            this.processJelly(file);
        }
    }

    private void processDirectory(File dir) throws MojoExecutionException {
        File[] children = dir.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            this.process(child);
        }
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="TODO needs triage")
    private void processJelly(File file) throws MojoExecutionException {
        Set<String> props = this.findAllProperties(file);
        if (props.isEmpty()) {
            return;
        }
        Object fileName = file.getName();
        fileName = ((String)fileName).substring(0, ((String)fileName).length() - ".jelly".length());
        fileName = (String)fileName + "_" + this.locale + ".properties";
        File resourceFile = new File(file.getParentFile(), (String)fileName);
        if (resourceFile.exists()) {
            Properties resource;
            try {
                resource = new Properties(resourceFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read " + String.valueOf(resourceFile), (Exception)e);
            }
            HashSet<Object> unnecessaries = new HashSet<Object>(resource.keySet());
            unnecessaries.removeAll(props);
            for (String string : unnecessaries) {
                this.getLog().warn((CharSequence)("Unused property " + string + " in " + String.valueOf(resourceFile)));
            }
            props.removeAll(resource.keySet());
            try (RandomAccessFile f = new RandomAccessFile(resourceFile, "rw");){
                if (f.length() > 0L) {
                    f.seek(f.length() - 1L);
                    int n = f.read();
                    if (n != 13 && n != 10) {
                        f.write(System.getProperty("line.separator").getBytes());
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write " + String.valueOf(resourceFile), (Exception)e);
            }
        }
        if (props.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)("Updating " + String.valueOf(resourceFile)));
        try (RandomAccessFile f = new RandomAccessFile(resourceFile, "rw");){
            if (f.length() > 0L) {
                f.seek(f.length() - 1L);
                int ch = f.read();
                if (ch != 13 && ch != 10) {
                    f.write(System.getProperty("line.separator").getBytes());
                }
            }
            try (PrintWriter w = new PrintWriter(new FileWriter(resourceFile, true));){
                for (String string : props) {
                    w.println(this.escape(string) + "=");
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write " + String.valueOf(resourceFile), (Exception)e);
        }
    }

    private String escape(String key) {
        StringBuilder buf = new StringBuilder(key.length());
        block6: for (int i = 0; i < key.length(); ++i) {
            char ch = key.charAt(i);
            switch (ch) {
                case ' ': {
                    buf.append("\\ ");
                    continue block6;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block6;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block6;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    buf.append('\\').append(ch);
                    continue block6;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    private Set<String> findAllProperties(File file) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Parsing " + String.valueOf(file)));
        try {
            final LinkedHashSet<String> properties = new LinkedHashSet<String>();
            this.parser.parse(file, new DefaultHandler(){
                private final StringBuilder buf = new StringBuilder();
                private Locator locator;

                @Override
                public void setDocumentLocator(Locator locator) {
                    this.locator = locator;
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    this.findExpressions();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        this.buf.append(attributes.getValue(i));
                        this.findExpressions();
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    this.findExpressions();
                }

                @Override
                public void characters(char[] ch, int start, int length) {
                    this.buf.append(ch, start, length);
                }

                private void findExpressions() throws SAXParseException {
                    int idx = -1;
                    while ((idx = this.buf.indexOf("${", idx + 1)) >= 0) {
                        int end = this.buf.indexOf("}", idx);
                        if (end == -1) {
                            throw new SAXParseException("Missing '}'", this.locator);
                        }
                        this.onJexlExpression(this.buf.substring(idx + 2, end));
                    }
                    this.buf.setLength(0);
                }

                private void onJexlExpression(String exp) {
                    if (exp.startsWith("%")) {
                        LocalizerMojo.this.getLog().debug((CharSequence)("Found " + exp));
                        exp = exp.substring(1);
                        int op = exp.indexOf(40);
                        if (op >= 0) {
                            exp = exp.substring(0, op);
                        }
                        properties.add(exp);
                    } else {
                        Matcher m = RESOURCE_LITERAL_STRING.matcher(exp);
                        while (m.find()) {
                            String literal = m.group();
                            LocalizerMojo.this.getLog().debug((CharSequence)("Found " + literal));
                            literal = literal.substring(2, literal.length() - 1);
                            int op = literal.indexOf(40);
                            if (op >= 0) {
                                literal = literal.substring(0, op);
                            }
                            properties.add(literal);
                        }
                    }
                }
            });
            return properties;
        }
        catch (IOException | SAXException e) {
            throw new MojoExecutionException("Failed to parse " + String.valueOf(file), e);
        }
    }
}

