/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.webhookexternalstore;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.XmlFile;
import hudson.model.ModelObject;
import hudson.security.Permission;
import io.jenkins.plugins.webhookexternalstore.WebhookCredentialsProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.ExportedBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

public class WebhookCredentialsStore
extends CredentialsStore {
    private static final Logger LOG = LoggerFactory.getLogger((String)WebhookCredentialsStore.class.getName());
    private final transient WebhookCredentialsProvider provider;
    private final transient WebhookCredentialsStoreAction action = new WebhookCredentialsStoreAction(this);
    private List<IdCredentials> credentials = new ArrayList<IdCredentials>();

    public WebhookCredentialsStore(@NonNull WebhookCredentialsProvider provider, @NonNull ModelObject context) {
        super(WebhookCredentialsProvider.class);
        this.provider = provider;
        this.load();
    }

    @NonNull
    public ModelObject getContext() {
        return Jenkins.get();
    }

    public boolean hasPermission2(@NonNull Authentication authentication, @NonNull Permission permission) {
        if (!CredentialsProvider.VIEW.equals((Object)permission)) {
            return false;
        }
        return Jenkins.get().getACL().hasPermission2(authentication, permission);
    }

    @NonNull
    public List<Credentials> getCredentials(@NonNull Domain domain) {
        if (!Domain.global().equals((Object)domain)) {
            return Collections.emptyList();
        }
        return new ArrayList<IdCredentials>(this.provider.getAllWebhookCredentials());
    }

    public boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) {
        throw new UnsupportedOperationException();
    }

    public boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) {
        throw new UnsupportedOperationException();
    }

    public boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public List<Domain> getDomains() {
        return Collections.singletonList(Domain.global());
    }

    @CheckForNull
    public CredentialsStoreAction getStoreAction() {
        return this.action;
    }

    public synchronized void save() throws IOException {
        this.credentials = new ArrayList<IdCredentials>(this.provider.getAllWebhookCredentials());
        WebhookCredentialsStore.getConfigFile().write((Object)this);
    }

    protected synchronized void load() {
        XmlFile xml = WebhookCredentialsStore.getConfigFile();
        if (xml.exists()) {
            try {
                xml.unmarshal((Object)this);
                this.provider.setCredentials(this.credentials);
            }
            catch (IOException e) {
                LOG.error("Failed to load credentials from configuration file: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public static XmlFile getConfigFile() {
        return new XmlFile((XStream)Jenkins.XSTREAM2, new File(Jenkins.get().getRootDir(), "webhook-credentials.xml"));
    }

    @ExportedBean
    public static class WebhookCredentialsStoreAction
    extends CredentialsStoreAction {
        private final WebhookCredentialsStore store;

        private WebhookCredentialsStoreAction(WebhookCredentialsStore store) {
            this.store = store;
        }

        @NonNull
        public CredentialsStore getStore() {
            return this.store;
        }

        public String getDisplayName() {
            return "Webhooks";
        }
    }
}

