/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.trunk.utils;

import com.coravy.hudson.plugins.github.GithubProjectProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import io.jenkins.plugins.trunk.model.Repo;
import io.jenkins.plugins.trunk.utils.JobUtil;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class ScmUtil {
    private static final Logger LOG = Logger.getLogger(ScmUtil.class.getName());

    public static List<Repo> getRepos(@NonNull Run<?, ?> run, TaskListener listener) {
        WorkflowRun workflowRun;
        PrintStream buildConsolePrinter = listener.getLogger();
        ArrayList<Repo> repos = new ArrayList<Repo>();
        buildConsolePrinter.println("Scanning for git remotes");
        Job job = run.getParent();
        GithubProjectProperty github = (GithubProjectProperty)job.getProperty(GithubProjectProperty.class);
        if (github != null) {
            String url = github.getProjectUrl().toString();
            LOG.info(String.format("Found github remote: %s", url));
            listener.getLogger().printf("Found github remote: %s%n", url);
            repos.add(Repo.fromGitUrl(url));
        }
        if (repos.isEmpty() && (workflowRun = JobUtil.asWorkflowRun(run)) != null) {
            workflowRun.getSCMs().forEach(scm -> {
                if (scm instanceof GitSCM) {
                    GitSCM git = (GitSCM)scm;
                    git.getUserRemoteConfigs().forEach(remote -> {
                        LOG.info(String.format("Found git remote: %s", remote.getUrl()));
                        listener.getLogger().printf("Found git remote: %s%n", remote.getUrl());
                        String url = remote.getUrl();
                        if (StringUtils.isNotEmpty((String)url)) {
                            repos.add(Repo.fromGitUrl(url));
                        }
                    });
                }
            });
        }
        if (repos.isEmpty()) {
            LOG.warning("No git remotes found");
            listener.getLogger().println("Trunk plugin requires a git remote to be configured");
        }
        return repos;
    }
}

