/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.trunk.model.service;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.trunk.model.Repo;
import io.jenkins.plugins.trunk.model.event.ActivityEventForm;
import io.jenkins.plugins.trunk.model.service.TrackEventsRequest;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="TrackEventsRequest", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableTrackEventsRequest
implements TrackEventsRequest {
    private final Repo repo;
    private final ImmutableList<ActivityEventForm> events;

    private ImmutableTrackEventsRequest(Repo repo, ImmutableList<ActivityEventForm> events) {
        this.repo = repo;
        this.events = events;
    }

    @Override
    public Repo repo() {
        return this.repo;
    }

    public ImmutableList<ActivityEventForm> events() {
        return this.events;
    }

    public final ImmutableTrackEventsRequest withRepo(Repo value) {
        if (this.repo == value) {
            return this;
        }
        Repo newValue = Objects.requireNonNull(value, "repo");
        return new ImmutableTrackEventsRequest(newValue, this.events);
    }

    public final ImmutableTrackEventsRequest withEvents(ActivityEventForm ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTrackEventsRequest(this.repo, (ImmutableList<ActivityEventForm>)newValue);
    }

    public final ImmutableTrackEventsRequest withEvents(Iterable<? extends ActivityEventForm> elements) {
        if (this.events == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTrackEventsRequest(this.repo, (ImmutableList<ActivityEventForm>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTrackEventsRequest && this.equalTo(0, (ImmutableTrackEventsRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableTrackEventsRequest another) {
        return this.repo.equals(another.repo) && this.events.equals(another.events);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.repo.hashCode();
        h += (h << 5) + this.events.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TrackEventsRequest").omitNullValues().add("repo", (Object)this.repo).add("events", this.events).toString();
    }

    public static ImmutableTrackEventsRequest copyOf(TrackEventsRequest instance) {
        if (instance instanceof ImmutableTrackEventsRequest) {
            return (ImmutableTrackEventsRequest)instance;
        }
        return ImmutableTrackEventsRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TrackEventsRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REPO = 1L;
        private long initBits = 1L;
        @Nullable
        private Repo repo;
        private ImmutableList.Builder<ActivityEventForm> events = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(TrackEventsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.repo(instance.repo());
            this.addAllEvents(instance.events());
            return this;
        }

        public final Builder repo(Repo repo) {
            this.repo = Objects.requireNonNull(repo, "repo");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addEvents(ActivityEventForm element) {
            this.events.add((Object)element);
            return this;
        }

        public final Builder addEvents(ActivityEventForm ... elements) {
            this.events.add((Object[])elements);
            return this;
        }

        public final Builder events(Iterable<? extends ActivityEventForm> elements) {
            this.events = ImmutableList.builder();
            return this.addAllEvents(elements);
        }

        public final Builder addAllEvents(Iterable<? extends ActivityEventForm> elements) {
            this.events.addAll(elements);
            return this;
        }

        public ImmutableTrackEventsRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTrackEventsRequest(this.repo, (ImmutableList<ActivityEventForm>)this.events.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("repo");
            }
            return "Cannot build TrackEventsRequest, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

