/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.trunk.model.event;

import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.trunk.model.event.SequenceForm;
import io.jenkins.plugins.trunk.model.event.SequencePayloadForm;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SequenceForm", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSequenceForm
implements SequenceForm {
    private final String platform;
    private final String kind;
    private final String key;
    private final String name;
    private final SequencePayloadForm payload;

    private ImmutableSequenceForm(String platform, String kind, String key, String name, SequencePayloadForm payload) {
        this.platform = platform;
        this.kind = kind;
        this.key = key;
        this.name = name;
        this.payload = payload;
    }

    @Override
    public String platform() {
        return this.platform;
    }

    @Override
    public String kind() {
        return this.kind;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public SequencePayloadForm payload() {
        return this.payload;
    }

    public final ImmutableSequenceForm withPlatform(String value) {
        String newValue = Objects.requireNonNull(value, "platform");
        if (this.platform.equals(newValue)) {
            return this;
        }
        return new ImmutableSequenceForm(newValue, this.kind, this.key, this.name, this.payload);
    }

    public final ImmutableSequenceForm withKind(String value) {
        String newValue = Objects.requireNonNull(value, "kind");
        if (this.kind.equals(newValue)) {
            return this;
        }
        return new ImmutableSequenceForm(this.platform, newValue, this.key, this.name, this.payload);
    }

    public final ImmutableSequenceForm withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableSequenceForm(this.platform, this.kind, newValue, this.name, this.payload);
    }

    public final ImmutableSequenceForm withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableSequenceForm(this.platform, this.kind, this.key, newValue, this.payload);
    }

    public final ImmutableSequenceForm withPayload(SequencePayloadForm value) {
        if (this.payload == value) {
            return this;
        }
        SequencePayloadForm newValue = Objects.requireNonNull(value, "payload");
        return new ImmutableSequenceForm(this.platform, this.kind, this.key, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSequenceForm && this.equalTo(0, (ImmutableSequenceForm)another);
    }

    private boolean equalTo(int synthetic, ImmutableSequenceForm another) {
        return this.platform.equals(another.platform) && this.kind.equals(another.kind) && this.key.equals(another.key) && this.name.equals(another.name) && this.payload.equals(another.payload);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.platform.hashCode();
        h += (h << 5) + this.kind.hashCode();
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.payload.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SequenceForm").omitNullValues().add("platform", (Object)this.platform).add("kind", (Object)this.kind).add("key", (Object)this.key).add("name", (Object)this.name).add("payload", (Object)this.payload).toString();
    }

    public static ImmutableSequenceForm copyOf(SequenceForm instance) {
        if (instance instanceof ImmutableSequenceForm) {
            return (ImmutableSequenceForm)instance;
        }
        return ImmutableSequenceForm.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SequenceForm", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PLATFORM = 1L;
        private static final long INIT_BIT_KIND = 2L;
        private static final long INIT_BIT_KEY = 4L;
        private static final long INIT_BIT_NAME = 8L;
        private static final long INIT_BIT_PAYLOAD = 16L;
        private long initBits = 31L;
        @Nullable
        private String platform;
        @Nullable
        private String kind;
        @Nullable
        private String key;
        @Nullable
        private String name;
        @Nullable
        private SequencePayloadForm payload;

        private Builder() {
        }

        public final Builder from(SequenceForm instance) {
            Objects.requireNonNull(instance, "instance");
            this.platform(instance.platform());
            this.kind(instance.kind());
            this.key(instance.key());
            this.name(instance.name());
            this.payload(instance.payload());
            return this;
        }

        public final Builder platform(String platform) {
            this.platform = Objects.requireNonNull(platform, "platform");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder kind(String kind) {
            this.kind = Objects.requireNonNull(kind, "kind");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder payload(SequencePayloadForm payload) {
            this.payload = Objects.requireNonNull(payload, "payload");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableSequenceForm build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSequenceForm(this.platform, this.kind, this.key, this.name, this.payload);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("platform");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("kind");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("payload");
            }
            return "Cannot build SequenceForm, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

