/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.trunk.model.event;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Doubles;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.trunk.model.event.ActivityMetricForm;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ActivityMetricForm", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableActivityMetricForm
implements ActivityMetricForm {
    private final String k;
    private final double v;

    private ImmutableActivityMetricForm(String k, double v) {
        this.k = k;
        this.v = v;
    }

    @Override
    public String k() {
        return this.k;
    }

    @Override
    public double v() {
        return this.v;
    }

    public final ImmutableActivityMetricForm withK(String value) {
        String newValue = Objects.requireNonNull(value, "k");
        if (this.k.equals(newValue)) {
            return this;
        }
        return new ImmutableActivityMetricForm(newValue, this.v);
    }

    public final ImmutableActivityMetricForm withV(double value) {
        if (Double.doubleToLongBits(this.v) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableActivityMetricForm(this.k, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableActivityMetricForm && this.equalTo(0, (ImmutableActivityMetricForm)another);
    }

    private boolean equalTo(int synthetic, ImmutableActivityMetricForm another) {
        return this.k.equals(another.k) && Double.doubleToLongBits(this.v) == Double.doubleToLongBits(another.v);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.k.hashCode();
        h += (h << 5) + Doubles.hashCode((double)this.v);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ActivityMetricForm").omitNullValues().add("k", (Object)this.k).add("v", this.v).toString();
    }

    public static ImmutableActivityMetricForm copyOf(ActivityMetricForm instance) {
        if (instance instanceof ImmutableActivityMetricForm) {
            return (ImmutableActivityMetricForm)instance;
        }
        return ImmutableActivityMetricForm.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ActivityMetricForm", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_K = 1L;
        private static final long INIT_BIT_V = 2L;
        private long initBits = 3L;
        @Nullable
        private String k;
        private double v;

        private Builder() {
        }

        public final Builder from(ActivityMetricForm instance) {
            Objects.requireNonNull(instance, "instance");
            this.k(instance.k());
            this.v(instance.v());
            return this;
        }

        public final Builder k(String k) {
            this.k = Objects.requireNonNull(k, "k");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder v(double v) {
            this.v = v;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableActivityMetricForm build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableActivityMetricForm(this.k, this.v);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("k");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("v");
            }
            return "Cannot build ActivityMetricForm, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

