/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.trunk.model.event;

import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.trunk.model.event.ActivityEventParent;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ActivityEventParent", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableActivityEventParent
implements ActivityEventParent {
    private final String eventId;
    private final String sequenceKey;

    private ImmutableActivityEventParent(String eventId, String sequenceKey) {
        this.eventId = eventId;
        this.sequenceKey = sequenceKey;
    }

    @Override
    public String eventId() {
        return this.eventId;
    }

    @Override
    public String sequenceKey() {
        return this.sequenceKey;
    }

    public final ImmutableActivityEventParent withEventId(String value) {
        String newValue = Objects.requireNonNull(value, "eventId");
        if (this.eventId.equals(newValue)) {
            return this;
        }
        return new ImmutableActivityEventParent(newValue, this.sequenceKey);
    }

    public final ImmutableActivityEventParent withSequenceKey(String value) {
        String newValue = Objects.requireNonNull(value, "sequenceKey");
        if (this.sequenceKey.equals(newValue)) {
            return this;
        }
        return new ImmutableActivityEventParent(this.eventId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableActivityEventParent && this.equalTo(0, (ImmutableActivityEventParent)another);
    }

    private boolean equalTo(int synthetic, ImmutableActivityEventParent another) {
        return this.eventId.equals(another.eventId) && this.sequenceKey.equals(another.sequenceKey);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.eventId.hashCode();
        h += (h << 5) + this.sequenceKey.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ActivityEventParent").omitNullValues().add("eventId", (Object)this.eventId).add("sequenceKey", (Object)this.sequenceKey).toString();
    }

    public static ImmutableActivityEventParent copyOf(ActivityEventParent instance) {
        if (instance instanceof ImmutableActivityEventParent) {
            return (ImmutableActivityEventParent)instance;
        }
        return ImmutableActivityEventParent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ActivityEventParent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EVENT_ID = 1L;
        private static final long INIT_BIT_SEQUENCE_KEY = 2L;
        private long initBits = 3L;
        @Nullable
        private String eventId;
        @Nullable
        private String sequenceKey;

        private Builder() {
        }

        public final Builder from(ActivityEventParent instance) {
            Objects.requireNonNull(instance, "instance");
            this.eventId(instance.eventId());
            this.sequenceKey(instance.sequenceKey());
            return this;
        }

        public final Builder eventId(String eventId) {
            this.eventId = Objects.requireNonNull(eventId, "eventId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder sequenceKey(String sequenceKey) {
            this.sequenceKey = Objects.requireNonNull(sequenceKey, "sequenceKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableActivityEventParent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableActivityEventParent(this.eventId, this.sequenceKey);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("eventId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sequenceKey");
            }
            return "Cannot build ActivityEventParent, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

