/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.trunk.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.trunk.model.ImmutableRepo;
import org.immutables.value.Value;

@Value.Immutable
public interface Repo {
    public static Repo github(String owner, String name) {
        return ImmutableRepo.builder().host("github.com").owner(owner).name(name).build();
    }

    public static String getFullName(@NonNull Repo repo) {
        return String.format("%s/%s", repo.owner(), repo.name());
    }

    public static Repo fromGitUrl(String gitRepoUrl) {
        String[] parts = gitRepoUrl.split("/");
        if (parts.length != 5) {
            throw new IllegalArgumentException("Invalid repo URL: " + gitRepoUrl);
        }
        String host = parts[2];
        String owner = parts[3];
        String name = parts[4].replace(".git", "");
        return ImmutableRepo.builder().host(host).owner(owner).name(name).build();
    }

    public String host();

    public String owner();

    public String name();
}

