/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.trunk.model;

import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.trunk.model.Repo;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Repo", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableRepo
implements Repo {
    private final String host;
    private final String owner;
    private final String name;

    private ImmutableRepo(String host, String owner, String name) {
        this.host = host;
        this.owner = owner;
        this.name = name;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public String owner() {
        return this.owner;
    }

    @Override
    public String name() {
        return this.name;
    }

    public final ImmutableRepo withHost(String value) {
        String newValue = Objects.requireNonNull(value, "host");
        if (this.host.equals(newValue)) {
            return this;
        }
        return new ImmutableRepo(newValue, this.owner, this.name);
    }

    public final ImmutableRepo withOwner(String value) {
        String newValue = Objects.requireNonNull(value, "owner");
        if (this.owner.equals(newValue)) {
            return this;
        }
        return new ImmutableRepo(this.host, newValue, this.name);
    }

    public final ImmutableRepo withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRepo(this.host, this.owner, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRepo && this.equalTo(0, (ImmutableRepo)another);
    }

    private boolean equalTo(int synthetic, ImmutableRepo another) {
        return this.host.equals(another.host) && this.owner.equals(another.owner) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + this.owner.hashCode();
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Repo").omitNullValues().add("host", (Object)this.host).add("owner", (Object)this.owner).add("name", (Object)this.name).toString();
    }

    public static ImmutableRepo copyOf(Repo instance) {
        if (instance instanceof ImmutableRepo) {
            return (ImmutableRepo)instance;
        }
        return ImmutableRepo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Repo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HOST = 1L;
        private static final long INIT_BIT_OWNER = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private long initBits = 7L;
        @Nullable
        private String host;
        @Nullable
        private String owner;
        @Nullable
        private String name;

        private Builder() {
        }

        public final Builder from(Repo instance) {
            Objects.requireNonNull(instance, "instance");
            this.host(instance.host());
            this.owner(instance.owner());
            this.name(instance.name());
            return this;
        }

        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder owner(String owner) {
            this.owner = Objects.requireNonNull(owner, "owner");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableRepo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRepo(this.host, this.owner, this.name);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("host");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("owner");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Repo, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

