/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.trunk.listeners;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.FreeStyleBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import io.jenkins.plugins.trunk.ActivityHandler;
import io.jenkins.plugins.trunk.Configuration;
import io.jenkins.plugins.trunk.InitTimeAction;
import io.jenkins.plugins.trunk.RunTracker;
import io.jenkins.plugins.trunk.TrunkLog;
import io.jenkins.plugins.trunk.utils.JobUtil;
import io.jenkins.plugins.trunk.utils.NodeUtil;
import io.jenkins.plugins.trunk.utils.ScmUtil;
import io.jenkins.plugins.trunk.utils.SecretsUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Extension
public class JenkinsActivityListener
extends RunListener<Run<?, ?>>
implements GraphListener {
    private static final Logger LOG = Logger.getLogger(JenkinsActivityListener.class.getName());
    private final ActivityHandler handler = new ActivityHandler();
    private final RunTracker runTracker = new RunTracker();

    public void onInitialize(Run<?, ?> run) {
        this.runTracker.trackRun(run);
        run.addAction((Action)new InitTimeAction());
    }

    public void onStarted(Run<?, ?> run, @NonNull TaskListener listener) {
        if (this.hasValidState(run, Configuration.get())) {
            run.addAction((Action)new TimingAction());
            WorkflowRun workflowRun = JobUtil.asWorkflowRun(run);
            FreeStyleBuild freestyleBuild = JobUtil.asFreestyleBuild(run);
            if (workflowRun != null) {
                workflowRun.getExecutionPromise().addListener(() -> this.handler.onRunStarted((Run<?, ?>)workflowRun, ScmUtil.getRepos(workflowRun, listener)), (Executor)Executors.newSingleThreadExecutor());
            } else if (freestyleBuild != null) {
                this.handler.onRunStarted((Run<?, ?>)freestyleBuild, ScmUtil.getRepos(freestyleBuild, listener));
            }
        }
    }

    public void onCompleted(Run<?, ?> run, @NonNull TaskListener listener) {
        if (this.hasValidState(run, Configuration.get())) {
            this.handler.onRunCompleted(run);
        }
    }

    public void onNewHead(FlowNode endNode) {
        if (this.hasValidState((Run<?, ?>)NodeUtil.getNodeRun(endNode), Configuration.get())) {
            BlockStartNode startNode;
            TimingAction timingAction;
            if (NodeUtil.isStartNode(endNode) && NodeUtil.isStageNode(endNode)) {
                this.handler.onStageStarted(endNode);
                return;
            }
            if (NodeUtil.isEndNode(endNode) && (timingAction = (TimingAction)(startNode = ((BlockEndNode)endNode).getStartNode()).getAction(TimingAction.class)) != null && NodeUtil.isStageNode((FlowNode)startNode)) {
                this.handler.onStageCompleted((FlowNode)startNode, endNode);
            }
        }
    }

    boolean hasValidState(@CheckForNull Run<?, ?> run, @CheckForNull Configuration cfg) {
        if (run == null) {
            TrunkLog.warning("Run is null");
            return false;
        }
        if (!this.runTracker.isRunTracked(run)) {
            TrunkLog.warning(String.format("Run %s is not started", run));
            return false;
        }
        if (cfg == null) {
            TrunkLog.warning("Trunk configuration is not set");
            return false;
        }
        if (StringUtils.isEmpty((String)cfg.trunkApi)) {
            TrunkLog.warning("Trunk API is not set");
            return false;
        }
        if (StringUtils.isEmpty((String)SecretsUtil.getTrunkToken())) {
            TrunkLog.warning("TRUNK_TOKEN secret not found");
            return false;
        }
        return true;
    }
}

