/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.trunk.client;

import com.google.gson.Gson;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.trunk.TrunkLog;
import io.jenkins.plugins.trunk.model.Metadata;
import io.jenkins.plugins.trunk.model.Repo;
import io.jenkins.plugins.trunk.model.event.ActivityEventForm;
import io.jenkins.plugins.trunk.model.event.ActivityPayloadForm;
import io.jenkins.plugins.trunk.model.service.TrackEventsRequest;
import java.io.IOException;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class TrunkClient {
    private static final String SOURCE = "jenkins-plugin";
    private static final String TRACK_EVENTS_PATH = "/v1/metrics/trackEvents";
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json");
    private static final Logger LOG = Logger.getLogger(TrunkClient.class.getName());
    private final String rpcUrl;
    private final Gson gson;
    private final OkHttpClient inner;

    public TrunkClient(OkHttpClient inner, Gson gson, String trunkApi) {
        this.gson = gson;
        this.inner = inner;
        this.rpcUrl = String.format("%s%s", trunkApi, TRACK_EVENTS_PATH);
    }

    public void trackEvents(@NonNull TrackEventsRequest req, @NonNull Metadata md) {
        for (ActivityEventForm event : req.events()) {
            TrunkLog.info(String.format("Tracking event %s for repo %s", ActivityPayloadForm.getTitle(event.payload()), Repo.getFullName(req.repo())));
        }
        String body = this.gson.toJson((Object)req);
        Request httpReq = new Request.Builder().url(this.rpcUrl).header("x-api-token", md.token()).header("x-source", SOURCE).post(RequestBody.create((String)body, (MediaType)MEDIA_TYPE_JSON)).build();
        try (Response resp = this.inner.newCall(httpReq).execute();){
            if (!resp.isSuccessful()) {
                ResponseBody respBody = resp.body();
                if (respBody != null) {
                    LOG.warning(String.format("Failed to upload event to Trunk: %s", respBody.string()));
                } else {
                    LOG.warning(String.format("Failed to upload event to Trunk: %s", resp.message()));
                }
            }
        }
        catch (IOException e) {
            LOG.warning(String.format("Failed to upload event to Trunk: %s", e.getMessage()));
        }
    }
}

