/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.trunk;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import hudson.model.Run;
import io.jenkins.plugins.trunk.Mapper;
import java.util.concurrent.TimeUnit;

public class RunTracker {
    private final Cache<String, Boolean> traceStarted = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterWrite(7L, TimeUnit.DAYS).build();

    public void trackRun(Run<?, ?> run) {
        this.traceStarted.put((Object)Mapper.makeJobRunEventId(run), (Object)Boolean.TRUE);
    }

    public boolean isRunTracked(Run<?, ?> run) {
        return this.traceStarted.getIfPresent((Object)Mapper.makeJobRunEventId(run)) != null;
    }
}

