/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.trunk;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Actionable;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.plugins.trunk.model.event.ActivityConclusion;
import io.jenkins.plugins.trunk.model.event.ActivityEventForm;
import io.jenkins.plugins.trunk.model.event.ActivityEventParent;
import io.jenkins.plugins.trunk.model.event.ActivityMetricForm;
import io.jenkins.plugins.trunk.model.event.ActivityPayloadForm;
import io.jenkins.plugins.trunk.model.event.ActivityTagForm;
import io.jenkins.plugins.trunk.model.event.ActivityTimestampForm;
import io.jenkins.plugins.trunk.model.event.ImmutableActivityEventForm;
import io.jenkins.plugins.trunk.model.event.ImmutableActivityEventParent;
import io.jenkins.plugins.trunk.model.event.ImmutableActivityPayloadForm;
import io.jenkins.plugins.trunk.model.event.ImmutableSequenceForm;
import io.jenkins.plugins.trunk.model.event.ImmutableSequencePayloadForm;
import io.jenkins.plugins.trunk.model.event.SequenceForm;
import io.jenkins.plugins.trunk.utils.ActionUtil;
import io.jenkins.plugins.trunk.utils.IdGeneratorUtil;
import io.jenkins.plugins.trunk.utils.JobUtil;
import io.jenkins.plugins.trunk.utils.NodeUtil;
import io.jenkins.plugins.trunk.utils.VersionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public class Mapper {
    private static final Logger LOG = Logger.getLogger(Mapper.class.getName());
    private static final String VERSIONED_PLUGIN_ORIGIN = String.format("jenkins-plugin-%s", VersionUtil.getVersion());
    public static final String PLATFORM_JENKINS = "jenkins";
    public static final String KIND_PIPELINE = "pipeline";
    public static final String KIND_STAGE = "stage";

    public static ActivityEventForm newPipelineStartedEvent(@NonNull Run<?, ?> run) {
        return ImmutableActivityEventForm.builder().id(Mapper.makeJobRunEventId(run)).chainId(Mapper.makeJobRunChainId(run)).origin(VERSIONED_PLUGIN_ORIGIN).createdAt(run.getStartTimeInMillis()).conclusion(ActivityConclusion.UNSPECIFIED).payload(Mapper.makePipelineActivityEventPayloadForm(run)).sequence(Mapper.makePipelineSequenceForm(run)).build();
    }

    public static ActivityEventForm newPipelineCompletedEvent(@NonNull Run<?, ?> run) {
        long now = System.currentTimeMillis();
        return ImmutableActivityEventForm.builder().id(Mapper.makeJobRunEventId(run)).chainId(Mapper.makeJobRunChainId(run)).origin(VERSIONED_PLUGIN_ORIGIN).createdAt(run.getStartTimeInMillis()).finishedAt(now).conclusion(Mapper.resultToConclusion(run.getResult())).payload(Mapper.makePipelineActivityEventPayloadForm(run)).sequence(Mapper.makePipelineSequenceForm(run)).build();
    }

    public static ActivityEventForm newStageStartedEvent(@NonNull Run<?, ?> run, @NonNull FlowNode node) {
        return ImmutableActivityEventForm.builder().id(Mapper.makeStageEventId(run, node)).chainId(Mapper.makeJobRunChainId(run)).parent(Mapper.makeStageParent(run, node)).origin(VERSIONED_PLUGIN_ORIGIN).createdAt(ActionUtil.getStartTimeMillis((Actionable)node)).conclusion(ActivityConclusion.UNSPECIFIED).payload(Mapper.makeStageActivityEventPayloadForm(run, node, null)).sequence(Mapper.makeStageSequenceForm(run, node)).build();
    }

    public static ActivityEventForm newStageCompletedEvent(@NonNull Run<?, ?> run, @NonNull FlowNode startNode, @NonNull FlowNode endNode) {
        return ImmutableActivityEventForm.builder().id(Mapper.makeStageEventId(run, startNode)).chainId(Mapper.makeJobRunChainId(run)).parent(Mapper.makeStageParent(run, startNode)).origin(VERSIONED_PLUGIN_ORIGIN).createdAt(ActionUtil.getStartTimeMillis((Actionable)startNode)).finishedAt(ActionUtil.getStartTimeMillis((Actionable)endNode)).conclusion(endNode.getError() == null ? ActivityConclusion.SUCCESS : ActivityConclusion.FAILURE).payload(Mapper.makeStageActivityEventPayloadForm(run, startNode, endNode)).sequence(Mapper.makeStageSequenceForm(run, startNode)).build();
    }

    public static SequenceForm makePipelineSequenceForm(@NonNull Run<?, ?> run) {
        return ImmutableSequenceForm.builder().platform(PLATFORM_JENKINS).kind(KIND_PIPELINE).key(Mapper.makeJobRunSequenceKey(run)).name(run.getParent().getName()).payload(ImmutableSequencePayloadForm.builder().tags(Collections.singletonList(ActivityTagForm.make("url", Mapper.makeSequenceUrl(run)))).build()).build();
    }

    public static ActivityPayloadForm makePipelineActivityEventPayloadForm(@NonNull Run<?, ?> run) {
        long now = System.currentTimeMillis();
        long duration = run.getResult() == null ? 0L : now - run.getStartTimeInMillis();
        long initDuration = ActionUtil.getStartTimeMillis(run) - ActionUtil.getInitTimeMillis(run);
        String type = "unknown";
        if (JobUtil.asWorkflowRun(run) != null) {
            type = KIND_PIPELINE;
        } else if (JobUtil.asFreestyleBuild(run) != null) {
            type = "freestyle";
        }
        return ImmutableActivityPayloadForm.builder().metrics(List.of(ActivityMetricForm.make("duration_ms", duration), ActivityMetricForm.make("init_ms", initDuration))).timestamps(Collections.singletonList(ActivityTimestampForm.make("init", ActionUtil.getInitTimeMillis(run)))).tags(List.of(ActivityTagForm.make("title", run.getDisplayName()), ActivityTagForm.make("url", Mapper.makeEventUrl(run)), ActivityTagForm.make("type", type), ActivityTagForm.make("build", Integer.toString(run.getNumber())))).build();
    }

    private static SequenceForm makeStageSequenceForm(@NonNull Run<?, ?> run, @NonNull FlowNode startNode) {
        return ImmutableSequenceForm.builder().platform(PLATFORM_JENKINS).kind(KIND_STAGE).key(Mapper.makeStageSequenceKey(run, startNode)).name(startNode.getDisplayName()).payload(ImmutableSequencePayloadForm.builder().tags(Collections.singletonList(ActivityTagForm.make("url", Mapper.makeEventUrl(run)))).build()).build();
    }

    private static ActivityPayloadForm makeStageActivityEventPayloadForm(@NonNull Run<?, ?> run, @NonNull FlowNode startNode, @Nullable FlowNode endNode) {
        long duration = endNode == null ? 0L : ActionUtil.getStartTimeMillis((Actionable)endNode) - ActionUtil.getStartTimeMillis((Actionable)startNode);
        return ImmutableActivityPayloadForm.builder().metrics(Collections.singletonList(ActivityMetricForm.make("duration_ms", duration))).tags(List.of(ActivityTagForm.make("path", Mapper.getFullPath(run, startNode)), ActivityTagForm.make("title", run.getDisplayName()), ActivityTagForm.make("url", Mapper.makeEventUrl(run)), ActivityTagForm.make("build", Integer.toString(run.getNumber())))).build();
    }

    private static String makeEventUrl(@NonNull Run<?, ?> run) {
        Jenkins j = Jenkins.get();
        return String.format("%s%s", j.getRootUrl(), run.getUrl());
    }

    private static String makeSequenceUrl(@NonNull Run<?, ?> run) {
        Jenkins j = Jenkins.get();
        return String.format("%s%s", j.getRootUrl(), run.getParent().getUrl());
    }

    private static ActivityConclusion resultToConclusion(Result result) {
        if (Result.SUCCESS.equals(result)) {
            return ActivityConclusion.SUCCESS;
        }
        if (Result.FAILURE.equals(result)) {
            return ActivityConclusion.FAILURE;
        }
        if (Result.ABORTED.equals(result)) {
            return ActivityConclusion.CANCELLED;
        }
        if (Result.UNSTABLE.equals(result)) {
            return ActivityConclusion.FAILURE;
        }
        if (Result.NOT_BUILT.equals(result)) {
            return ActivityConclusion.CANCELLED;
        }
        LOG.warning("Unknown result: " + String.valueOf(result));
        return ActivityConclusion.FAILURE;
    }

    private static String makeJobRunSequenceKey(@NonNull Run<?, ?> run) {
        return IdGeneratorUtil.hashString(run.getParent().getName());
    }

    public static String makeJobRunEventId(@NonNull Run<?, ?> run) {
        return String.format("%s#%s", Mapper.makeJobRunSequenceKey(run), run.getNumber());
    }

    private static String makeStageEventId(@NonNull Run<?, ?> run, @NonNull FlowNode node) {
        return String.format("%s#%s", Mapper.makeStageSequenceKey(run, node), run.getNumber());
    }

    private static ActivityEventParent makeStageParent(@NonNull Run<?, ?> run, @NonNull FlowNode node) {
        String parentSequenceKey = Mapper.makeStageParentSequenceKey(run, node);
        String parentEventId = String.format("%s#%d", parentSequenceKey, run.getNumber());
        return ImmutableActivityEventParent.builder().sequenceKey(parentSequenceKey).eventId(parentEventId).build();
    }

    private static String makeJobRunChainId(@NonNull Run<?, ?> run) {
        return Mapper.makeJobRunEventId(run);
    }

    private static List<FlowNode> getParentStages(@NonNull FlowNode node) {
        ArrayList<FlowNode> stages = new ArrayList<FlowNode>();
        for (BlockStartNode block : node.iterateEnclosingBlocks()) {
            if (!NodeUtil.isStageNode((FlowNode)block)) continue;
            stages.add((FlowNode)block);
        }
        return stages;
    }

    private static String getFullPath(@NonNull Run<?, ?> run, @NonNull FlowNode node) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(node.getDisplayName());
        Mapper.getParentStages(node).forEach(parent -> names.add(parent.getDisplayName()));
        names.add(run.getParent().getDisplayName());
        Collections.reverse(names);
        return String.join((CharSequence)"/", names);
    }

    private static String makeStageSequenceKey(@NonNull Run<?, ?> run, @NonNull FlowNode node) {
        return IdGeneratorUtil.hashString(Mapper.getFullPath(run, node));
    }

    private static String makeStageParentSequenceKey(Run<?, ?> run, FlowNode node) {
        List<FlowNode> parents = Mapper.getParentStages(node);
        if (parents.isEmpty()) {
            return Mapper.makeJobRunSequenceKey(run);
        }
        return Mapper.makeStageSequenceKey(run, parents.get(0));
    }
}

