/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.trunk;

import com.google.gson.Gson;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Run;
import io.jenkins.plugins.trunk.Configuration;
import io.jenkins.plugins.trunk.Mapper;
import io.jenkins.plugins.trunk.client.TrunkClient;
import io.jenkins.plugins.trunk.model.Metadata;
import io.jenkins.plugins.trunk.model.Repo;
import io.jenkins.plugins.trunk.model.event.ActivityEventForm;
import io.jenkins.plugins.trunk.model.service.TrackEventsRequest;
import io.jenkins.plugins.trunk.utils.SecretsUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class ActivityHandler {
    private static final Logger LOG = Logger.getLogger(ActivityHandler.class.getName());
    private final Gson gson = new Gson();
    private final OkHttpClient http = new OkHttpClient();
    private final Map<String, List<Repo>> reposByRunId = new ConcurrentHashMap<String, List<Repo>>();
    private final ExecutorService pool = Executors.newFixedThreadPool(8);

    public void onRunStarted(@NonNull Run<?, ?> run, List<Repo> repos) {
        this.reposByRunId.put(run.getId(), repos);
        ActivityEventForm event = Mapper.newPipelineStartedEvent(run);
        this.trackEventForRepos(repos, event);
    }

    public void onRunCompleted(@NonNull Run<?, ?> run) {
        List<Repo> repos = this.reposByRunId.get(run.getId());
        this.reposByRunId.remove(run.getId());
        if (repos != null) {
            ActivityEventForm event = Mapper.newPipelineCompletedEvent(run);
            this.trackEventForRepos(repos, event);
        }
    }

    public void onStageStarted(@NonNull FlowNode node) {
        try {
            WorkflowRun run = (WorkflowRun)node.getExecution().getOwner().getExecutable();
            List<Repo> repos = this.reposByRunId.get(run.getId());
            if (repos == null) {
                return;
            }
            ActivityEventForm event = Mapper.newStageStartedEvent(run, node);
            this.trackEventForRepos(repos, event);
        }
        catch (IOException e) {
            LOG.warning(e.getMessage());
        }
    }

    public void onStageCompleted(@NonNull FlowNode startNode, @NonNull FlowNode endNode) {
        try {
            WorkflowRun run = (WorkflowRun)startNode.getExecution().getOwner().getExecutable();
            List<Repo> repos = this.reposByRunId.get(run.getId());
            if (repos == null) {
                return;
            }
            ActivityEventForm event = Mapper.newStageCompletedEvent(run, startNode, endNode);
            this.trackEventForRepos(repos, event);
        }
        catch (IOException e) {
            LOG.warning(e.getMessage());
        }
    }

    private void trackEventForRepos(@NonNull List<Repo> repos, @NonNull ActivityEventForm event) {
        Configuration cfg = Configuration.get();
        TrunkClient client = new TrunkClient(this.http, this.gson, cfg.trunkApi);
        String token = SecretsUtil.getTrunkToken();
        if (token == null) {
            LOG.warning("Trunk token is not set");
            return;
        }
        Metadata md = Metadata.make(token);
        try {
            this.pool.invokeAll(repos.stream().map(repo -> () -> {
                client.trackEvents(TrackEventsRequest.forSingleEvent(repo, event), md);
                return null;
            }).collect(Collectors.toList()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warning(e.getMessage());
        }
    }
}

