/*
 * Decompiled with CFR 0.152.
 */
package com.delinea.secrets.jenkins.wrapper.cred;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.delinea.secrets.jenkins.wrapper.cred.UserCredentials;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"secretServer"})
public class ServerConfiguration
extends GlobalConfiguration {
    public static final String DEFAULT_ENVIRONMENT_VARIABLE_PREFIX = "TSS_";
    public static final String API_VERSION = "v1";
    private String credentialId;
    private String baseUrl;
    private String environmentVariablePrefix = "TSS_";
    private String proxyHost;
    private int proxyPort;
    private String proxyUsername;
    private Secret proxyPassword;
    private String apiVersion = "v1";
    private String noProxyHosts;
    private boolean useProxy;

    public static ServerConfiguration get() {
        return (ServerConfiguration)((Object)ExtensionList.lookupSingleton(ServerConfiguration.class));
    }

    static FormValidation checkBaseUrl(@QueryParameter String value) {
        try {
            new URL(value);
            return FormValidation.ok();
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)"Invalid URL");
        }
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    @DataBoundSetter
    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
        this.save();
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    @DataBoundSetter
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        this.save();
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    @DataBoundSetter
    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        this.save();
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @DataBoundSetter
    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
        this.save();
    }

    public Secret getProxyPassword() {
        return this.proxyPassword;
    }

    @DataBoundSetter
    public void setProxyPassword(Secret proxyPassword) {
        this.proxyPassword = proxyPassword;
        this.save();
    }

    public String getNoProxyHosts() {
        return this.noProxyHosts;
    }

    @DataBoundSetter
    public void setNoProxyHosts(String noProxyHosts) {
        this.noProxyHosts = noProxyHosts;
        this.save();
    }

    public ServerConfiguration() {
        this.load();
    }

    @POST
    public FormValidation doCheckBaseUrl(@QueryParameter String value) throws IOException, ServletException {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return FormValidation.error((String)"You do not have permission to perform this action");
        }
        return ServerConfiguration.checkBaseUrl(value);
    }

    @POST
    public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item item) {
        if (item == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || item != null && !item.hasPermission(Item.CONFIGURE)) {
            return new StandardListBoxModel();
        }
        return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, item, UserCredentials.class);
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    @DataBoundSetter
    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
        this.save();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @DataBoundSetter
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = StringUtils.removeEnd((String)baseUrl, (String)"/");
        this.save();
    }

    public String getEnvironmentVariablePrefix() {
        return this.environmentVariablePrefix;
    }

    @DataBoundSetter
    public void setEnvironmentVariablePrefix(String environmentVariablePrefix) {
        this.environmentVariablePrefix = environmentVariablePrefix;
        this.save();
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    @DataBoundSetter
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        this.save();
    }
}

