/*
 * Decompiled with CFR 0.152.
 */
package com.delinea.secrets.jenkins.util;

import hudson.ProxyConfiguration;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;

public class DelineaProxyUtil {
    private static final Logger LOGGER = Logger.getLogger(DelineaProxyUtil.class.getName());
    public static final String PROXY_HOST_PROPERTY = "proxy.host";
    public static final String PROXY_PORT_PROPERTY = "proxy.port";
    public static final String PROXY_USERNAME_PROPERTY = "proxy.username";
    public static final String PROXY_PASSWORD_PROPERTY = "proxy.password";

    public static Map<String, String> resolveProxy(String vaultUrl, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword, String noProxyHosts) {
        String proxySource;
        String activeProxyHost = proxyHost;
        String activeProxyPort = proxyPort;
        String activeProxyUser = proxyUsername;
        String activeProxyPass = proxyPassword;
        String targetHost = DelineaProxyUtil.extractHost(vaultUrl);
        if (StringUtils.isNotBlank((CharSequence)noProxyHosts) && DelineaProxyUtil.isHostInNoProxy(targetHost, noProxyHosts)) {
            LOGGER.info("[DelineaProxyUtil] Skipping proxy due to NO_PROXY match for: " + targetHost);
            String proxySource2 = "Direct Connection (NO_PROXY match)";
            return DelineaProxyUtil.logAndReturn(proxySource2, null, null, null, null);
        }
        if (StringUtils.isBlank((CharSequence)activeProxyHost) || StringUtils.isBlank((CharSequence)activeProxyPort)) {
            LOGGER.info("[DelineaProxyUtil] inside jenkins proxy");
            ProxyConfiguration jenkinsProxy = Jenkins.get().proxy;
            if (jenkinsProxy != null && StringUtils.isNotBlank((CharSequence)jenkinsProxy.name)) {
                String jenkinsNoProxy = DelineaProxyUtil.getNoProxyList(jenkinsProxy);
                if (DelineaProxyUtil.isHostInNoProxy(targetHost, jenkinsNoProxy)) {
                    LOGGER.info("[DelineaProxyUtil] Skipping Jenkins proxy due to NO_PROXY match for: " + targetHost);
                    String proxySource3 = "Direct Connection (NO_PROXY match)";
                    return DelineaProxyUtil.logAndReturn(proxySource3, null, null, null, null);
                }
                activeProxyHost = jenkinsProxy.name;
                activeProxyPort = String.valueOf(jenkinsProxy.port);
                activeProxyUser = jenkinsProxy.getUserName();
                activeProxyPass = jenkinsProxy.getPassword();
                proxySource = "Jenkins Global Proxy";
            } else {
                proxySource = "Direct Connection (no proxy configured)";
            }
        } else {
            proxySource = "Delinea Plugin Proxy";
        }
        return DelineaProxyUtil.logAndReturn(proxySource, activeProxyHost, activeProxyPort, activeProxyUser, activeProxyPass);
    }

    private static String extractHost(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        try {
            URI uri = new URI(url);
            return uri.getHost() != null ? uri.getHost() : url;
        }
        catch (URISyntaxException e) {
            return url;
        }
    }

    private static String getNoProxyList(ProxyConfiguration proxy) {
        if (proxy == null) {
            return "";
        }
        try {
            Field field = ProxyConfiguration.class.getDeclaredField("noProxyHost");
            field.setAccessible(true);
            Object value = field.get(proxy);
            if (value instanceof String && StringUtils.isNotBlank((CharSequence)((String)value))) {
                return (String)value;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.warning("[DelineaProxyUtil] Unable to access noProxyHost field: " + e.getMessage());
        }
        String sysNoProxy = System.getenv("NO_PROXY");
        if (StringUtils.isNotBlank((CharSequence)sysNoProxy)) {
            return sysNoProxy;
        }
        return System.getProperty("no_proxy", "");
    }

    private static boolean isHostInNoProxy(String host, String noProxyList) {
        if (StringUtils.isBlank((CharSequence)host) || StringUtils.isBlank((CharSequence)noProxyList)) {
            return false;
        }
        for (String entry : noProxyList.split(",")) {
            if (!StringUtils.isNotBlank((CharSequence)(entry = entry.trim())) || !host.equalsIgnoreCase(entry) && !host.endsWith(entry)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, String> logAndReturn(String source, String host, String port, String user, String pass) {
        String message = String.format("[DelineaProxyUtil] ---------- Proxy Configuration ----------%n    Source         : %s%n    Proxy Host     : %s%n    Proxy Port     : %s%n    Proxy Username : %s%n    Proxy Password : %s%n-------------------------------------------------------------%n", source, StringUtils.defaultString((String)host, (String)"(none)"), StringUtils.defaultString((String)port, (String)"(none)"), StringUtils.isNotBlank((CharSequence)user) ? "*****" : "(none)", StringUtils.isNotBlank((CharSequence)pass) ? "********" : "(none)");
        LOGGER.info(message);
        HashMap<String, String> proxyConfig = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)host)) {
            proxyConfig.put(PROXY_HOST_PROPERTY, host);
        }
        if (StringUtils.isNotBlank((CharSequence)port)) {
            proxyConfig.put(PROXY_PORT_PROPERTY, port);
        }
        if (StringUtils.isNotBlank((CharSequence)user)) {
            proxyConfig.put(PROXY_USERNAME_PROPERTY, user);
        }
        if (StringUtils.isNotBlank((CharSequence)pass)) {
            proxyConfig.put(PROXY_PASSWORD_PROPERTY, pass);
        }
        return proxyConfig;
    }
}

