/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.teamscale.jenkins.upload;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.teamscale.client.ITeamscaleService;
import com.teamscale.client.TeamscaleServiceGenerator;
import eu.cqse.teamscale.jenkins.upload.Messages;
import eu.cqse.teamscale.jenkins.upload.TeamscaleUploadPluginConfiguration;
import eu.cqse.teamscale.jenkins.upload.TeamscaleUploadPluginResult;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.jenkinsci.Symbol;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;
import retrofit2.Call;
import retrofit2.Response;

public class TeamscaleUploadBuilder
extends Notifier
implements SimpleBuildStep {
    private static final CredentialsMatcher MATCHER = CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)});
    private ITeamscaleService api;
    public static final String ERROR = "TS-ERROR: ";
    public static final String INFO = "TS-INFO: ";
    private final String url;
    private final String teamscaleProject;
    private final String partition;
    private @Nullable String repository;
    private final String uploadMessage;
    private final String includePattern;
    private final String reportFormatId;
    private @Nullable String revision;
    private String credentialsId;
    private @Nullable TeamscaleUploadPluginResult resultNoReports;
    private @Nullable TeamscaleUploadPluginResult resultOnUploadFailure;

    @DataBoundConstructor
    public TeamscaleUploadBuilder(String url, String credentialsId, String teamscaleProject, String partition, String uploadMessage, String includePattern, String reportFormatId, @Nullable String revision) {
        this.url = url;
        this.teamscaleProject = teamscaleProject;
        this.partition = partition;
        this.uploadMessage = uploadMessage;
        this.includePattern = includePattern;
        this.reportFormatId = reportFormatId;
        this.credentialsId = credentialsId;
        this.revision = Util.fixEmpty((String)revision);
    }

    public String getUrl() {
        return this.url;
    }

    public String getTeamscaleProject() {
        return this.teamscaleProject;
    }

    public String getPartition() {
        return this.partition;
    }

    public @Nullable String getRepository() {
        return this.repository;
    }

    public String getUploadMessage() {
        return this.uploadMessage;
    }

    public String getIncludePattern() {
        return this.includePattern;
    }

    public String getReportFormatId() {
        return this.reportFormatId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public @Nullable String getRevision() {
        return this.revision;
    }

    @DataBoundSetter
    public void setRevision(@Nullable String revision) {
        this.revision = Util.fixEmpty((String)revision);
    }

    @DataBoundSetter
    public void setRepository(@Nullable String repository) {
        this.repository = Util.fixEmpty((String)repository);
    }

    public @Nullable String getResultNoReports() {
        if (this.resultNoReports == null) {
            return null;
        }
        return this.resultNoReports.toString();
    }

    @DataBoundSetter
    public void setResultNoReports(String resultOnNoReports) {
        this.resultNoReports = Util.fixEmpty((String)resultOnNoReports) == null ? null : TeamscaleUploadPluginResult.valueOf(resultOnNoReports);
    }

    public @Nullable String getResultOnUploadFailure() {
        if (this.resultOnUploadFailure == null) {
            return null;
        }
        return this.resultOnUploadFailure.toString();
    }

    @DataBoundSetter
    public void setResultOnUploadFailure(String resultOnUploadFailure) {
        this.resultOnUploadFailure = Util.fixEmpty((String)resultOnUploadFailure) == null ? null : TeamscaleUploadPluginResult.valueOf(resultOnUploadFailure);
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        StandardUsernamePasswordCredentials credential = (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)this.credentialsId, StandardUsernamePasswordCredentials.class, run, (List)URIRequirementBuilder.fromUri((String)this.getUrl()).build());
        if (credential == null) {
            listener.getLogger().println("TS-ERROR: credentials are null");
            run.setResult(Result.FAILURE);
            return;
        }
        HttpUrl url = HttpUrl.parse((String)this.getUrl());
        if (url == null) {
            listener.getLogger().println("TS-ERROR: Failed to parse URL");
            run.setResult(Result.FAILURE);
            return;
        }
        this.api = (ITeamscaleService)TeamscaleServiceGenerator.createService(ITeamscaleService.class, (HttpUrl)url, (String)credential.getUsername(), (String)credential.getPassword().getPlainText(), (Duration)Duration.ofSeconds(60L), (Duration)Duration.ofSeconds(60L), (Interceptor[])new Interceptor[0]);
        String rev = this.getScmRevision(env);
        listener.getLogger().println("TS-INFO: revision: " + rev);
        if (rev == null) {
            listener.getLogger().println("TS-ERROR: Could not find any revision. Currently only GIT and SVN are supported.");
            run.setResult(Result.FAILURE);
            return;
        }
        Map reports = (Map)workspace.act((FilePath.FileCallable)new CoverageCollectingFileCallable(new String[]{this.getIncludePattern()}));
        if (reports.isEmpty()) {
            TeamscaleUploadPluginResult resultingResultNoReports = this.resultNoReports;
            if (resultingResultNoReports == null) {
                resultingResultNoReports = TeamscaleUploadPluginConfiguration.get().getResultNoReportsEnum();
            }
            String logLevel = ERROR;
            switch (resultingResultNoReports) {
                case IGNORE: {
                    logLevel = INFO;
                    break;
                }
                case UNSTABLE: {
                    run.setResult(Result.UNSTABLE);
                    break;
                }
                case FAILURE: {
                    run.setResult(Result.FAILURE);
                }
            }
            listener.getLogger().println(logLevel + "No files found to upload to Teamscale with pattern \"" + this.getIncludePattern() + "\"");
            return;
        }
        TeamscaleUploadPluginResult resultingResultOnUploadFailure = this.resultOnUploadFailure;
        if (resultingResultOnUploadFailure == null) {
            resultingResultOnUploadFailure = TeamscaleUploadPluginConfiguration.get().getResultOnUploadFailureEnum();
        }
        String logLevel = resultingResultOnUploadFailure == TeamscaleUploadPluginResult.IGNORE ? INFO : ERROR;
        if (!this.uploadReports(listener.getLogger(), logLevel, reports, rev)) {
            switch (resultingResultOnUploadFailure) {
                case IGNORE: {
                    break;
                }
                case UNSTABLE: {
                    run.setResult(Result.UNSTABLE);
                    break;
                }
                case FAILURE: {
                    run.setResult(Result.FAILURE);
                }
            }
        }
    }

    private String getScmRevision(EnvVars envVars) {
        Pattern p;
        Matcher m;
        if (this.revision != null && (m = (p = Pattern.compile("^((([a-f]|[0-9])+)|([0-9])+)$")).matcher(this.revision)).matches()) {
            return this.revision;
        }
        String gitCommit = (String)envVars.get((Object)"GIT_COMMIT");
        if (gitCommit != null) {
            return gitCommit;
        }
        return (String)envVars.get((Object)"SVN_REVISION");
    }

    private boolean uploadReports(PrintStream logger, String logLevel, Map<String, String> reports, String revision) {
        ArrayList<MultipartBody.Part> parts = new ArrayList<MultipartBody.Part>();
        for (Map.Entry<String, String> filenameAndReportContent : reports.entrySet()) {
            parts.add(MultipartBody.Part.createFormData((String)"report", (String)filenameAndReportContent.getKey(), (RequestBody)RequestBody.create((String)filenameAndReportContent.getValue(), (MediaType)MultipartBody.FORM)));
        }
        Call apiRequest = this.api.uploadExternalReports(this.getTeamscaleProject(), this.getReportFormatId().toUpperCase(), null, revision, this.getRepository(), true, this.getPartition(), this.getUploadMessage(), parts);
        try {
            Request request = apiRequest.request();
            long requestStartTime = System.nanoTime();
            logger.print(INFO + request.method() + " - ");
            logger.println(request.url());
            Response response = apiRequest.execute();
            long requestEndTime = System.nanoTime();
            double requestTimeInMs = (double)(requestEndTime - requestStartTime) / 1000000.0;
            if (!response.isSuccessful()) {
                try (ResponseBody body = response.errorBody();){
                    logger.printf("%sResponse - %s %s in %.1fms body:%n%s%n", logLevel, response.code(), response.message(), requestTimeInMs, body != null ? body.string() : "Empty");
                }
                return false;
            }
            logger.println(INFO + String.format("Response - %s in %.1fms", response.code(), requestTimeInMs));
            return true;
        }
        catch (IOException e) {
            logger.println(logLevel + "Failed to upload reports to Teamscale: " + e.getMessage());
            return false;
        }
    }

    private static class CoverageCollectingFileCallable
    extends MasterToSlaveFileCallable<Map<String, String>> {
        private static final long serialVersionUID = 1L;
        private final String[] includes;

        public CoverageCollectingFileCallable(String[] includes) {
            this.includes = includes;
        }

        public Map<String, String> invoke(File directory, VirtualChannel virtualChannel) throws IOException, InterruptedException {
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(directory);
            directoryScanner.setIncludes(this.includes);
            directoryScanner.scan();
            HashMap<String, String> reports = new HashMap<String, String>();
            for (String file : directoryScanner.getIncludedFiles()) {
                reports.put(file, FileUtils.readFileToString((File)new File(directory, file), (Charset)StandardCharsets.UTF_8));
            }
            return reports;
        }
    }

    @Symbol(value={"teamscale"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @POST
        public FormValidation doCheckUrl(@AncestorInPath Item item, @QueryParameter String value) throws IOException, ServletException {
            HttpUrl url = HttpUrl.parse((String)value);
            if (url == null) {
                return FormValidation.error((String)"Invalid URL");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckTeamscaleProject(@AncestorInPath Item item, @QueryParameter String value) throws IOException, ServletException {
            return this.getFormValidation(value);
        }

        @POST
        public FormValidation doCheckPartition(@AncestorInPath Item item, @QueryParameter String value) throws IOException, ServletException {
            return this.getFormValidation(value);
        }

        @POST
        public FormValidation doCheckUploadMessage(@AncestorInPath Item item, @QueryParameter String value) throws IOException, ServletException {
            return this.getFormValidation(value);
        }

        @POST
        public FormValidation doCheckIncludePattern(@AncestorInPath Item item, @QueryParameter String value) throws IOException, ServletException {
            return this.getFormValidation(value);
        }

        @POST
        public FormValidation doCheckReportFormatId(@AncestorInPath Item item, @QueryParameter String value) throws IOException, ServletException {
            return this.getFormValidation(value);
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String url, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeMatchingAs(item instanceof Queue.Task ? Tasks.getAuthenticationOf2((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM2, item, StandardUsernamePasswordCredentials.class, URIRequirementBuilder.fromUri((String)url).build(), MATCHER).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item item, @QueryParameter String url, @QueryParameter String value) {
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (value.startsWith("${") && value.endsWith("}")) {
                return FormValidation.warning((String)"Cannot validate expression based credentials");
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Upload will fail without credentials");
            }
            if (CredentialsProvider.listCredentialsInItem(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)(item instanceof Queue.Task ? Tasks.getAuthenticationOf2((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM2), (List)URIRequirementBuilder.fromUri((String)url).build(), (CredentialsMatcher)CredentialsMatchers.withId((String)value)).isEmpty()) {
                return FormValidation.error((String)"Cannot find currently selected credentials");
            }
            return FormValidation.ok();
        }

        private FormValidation getFormValidation(@QueryParameter String value) {
            if (value.isEmpty()) {
                return FormValidation.error((String)Messages.TeamscaleBuilder_DescriptorImpl_errors_requiredField());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public @NonNull String getDisplayName() {
            return Messages.TeamscaleBuilder_DescriptorImpl_DisplayName();
        }

        @POST
        public ListBoxModel doFillResultNoReportsItems(@AncestorInPath Item item, @QueryParameter String resultNoReports) {
            ListBoxModel items = new ListBoxModel();
            items.add("inherit", "");
            items.addAll((Collection)Arrays.stream(TeamscaleUploadPluginResult.values()).map(e -> new ListBoxModel.Option(e.toString())).collect(Collectors.toList()));
            return items;
        }

        @POST
        public FormValidation doCheckResultNoReports(@AncestorInPath Item item, @QueryParameter String value) {
            if (Util.fixEmpty((String)value) != null && Arrays.stream(TeamscaleUploadPluginResult.values()).noneMatch(a -> a.name().equals(value))) {
                return FormValidation.error((String)"Please specify a correct result when no reports.");
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillResultOnUploadFailureItems(@AncestorInPath Item item, @QueryParameter String resultOnUploadFailure) {
            ListBoxModel items = new ListBoxModel();
            items.add("inherit", "");
            items.addAll((Collection)Arrays.stream(TeamscaleUploadPluginResult.values()).map(e -> new ListBoxModel.Option(e.toString())).collect(Collectors.toList()));
            return items;
        }

        @POST
        public FormValidation doCheckResultOnUploadFailure(@AncestorInPath Item item, @QueryParameter String value) {
            if (Util.fixEmpty((String)value) != null && Arrays.stream(TeamscaleUploadPluginResult.values()).noneMatch(a -> a.name().equals(value))) {
                return FormValidation.error((String)"Please specify a correct result on upload failure.");
            }
            return FormValidation.ok();
        }
    }
}

