/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.swarmcloud.gc;

import com.github.dockerjava.api.model.Service;
import com.github.dockerjava.api.model.ServiceSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import io.jenkins.plugins.swarmcloud.SwarmAgent;
import io.jenkins.plugins.swarmcloud.SwarmCloud;
import io.jenkins.plugins.swarmcloud.api.DockerSwarmClient;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class OrphanServiceCleaner
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(OrphanServiceCleaner.class.getName());
    private static final long RECURRENCE_PERIOD = TimeUnit.MINUTES.toMillis(5L);
    private static final long MAX_SERVICE_AGE = TimeUnit.HOURS.toMillis(24L);
    private static final long GRACE_PERIOD = TimeUnit.MINUTES.toMillis(10L);

    public OrphanServiceCleaner() {
        super("Swarm Agent Orphan Service Cleaner");
    }

    public long getRecurrencePeriod() {
        return RECURRENCE_PERIOD;
    }

    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return;
        }
        LOGGER.log(Level.FINE, "Starting orphan service cleanup");
        int totalCleaned = 0;
        for (Cloud cloud : jenkins.clouds) {
            if (!(cloud instanceof SwarmCloud)) continue;
            SwarmCloud swarmCloud = (SwarmCloud)cloud;
            int cleaned = this.cleanOrphanServices(swarmCloud, jenkins, listener);
            totalCleaned += cleaned;
        }
        if (totalCleaned > 0) {
            LOGGER.log(Level.INFO, "Orphan service cleanup completed. Cleaned: {0}", totalCleaned);
        } else {
            LOGGER.log(Level.FINE, "Orphan service cleanup completed. No services cleaned");
        }
    }

    private int cleanOrphanServices(SwarmCloud cloud, Jenkins jenkins, TaskListener listener) {
        int cleaned = 0;
        try {
            DockerSwarmClient dockerClient = cloud.getDockerClient();
            Set<String> knownAgentNames = this.getKnownAgentNames(jenkins, cloud.name);
            List<Service> services = dockerClient.listServicesForCloud(cloud.name);
            LOGGER.log(Level.FINE, "Found {0} services for cloud: {1}", new Object[]{services.size(), cloud.name});
            long now = System.currentTimeMillis();
            for (Service service : services) {
                boolean isTooOld;
                ServiceSpec serviceSpec = service.getSpec();
                if (serviceSpec == null) continue;
                String serviceName = serviceSpec.getName();
                Map labels = serviceSpec.getLabels();
                if (labels == null || !"true".equals(labels.get("jenkins.agent"))) continue;
                String createdStr = (String)labels.get("jenkins.created");
                long createdTime = 0L;
                if (createdStr != null) {
                    try {
                        createdTime = Long.parseLong(createdStr);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.log(Level.FINE, "Invalid creation time for service: {0}", serviceName);
                    }
                }
                if (createdTime > 0L && now - createdTime < GRACE_PERIOD) {
                    LOGGER.log(Level.FINE, "Service {0} is within grace period, skipping", serviceName);
                    continue;
                }
                String agentName = (String)labels.get("jenkins.agent.name");
                if (agentName == null) {
                    agentName = serviceName;
                }
                boolean isOrphan = !knownAgentNames.contains(agentName);
                boolean bl = isTooOld = createdTime > 0L && now - createdTime > MAX_SERVICE_AGE;
                if (!isOrphan && !isTooOld) continue;
                String reason = isOrphan ? "orphan (no Jenkins node)" : "too old";
                LOGGER.log(Level.FINE, "Removing {0} service: {1}", new Object[]{reason, serviceName});
                try {
                    String serviceId = service.getId();
                    if (serviceId != null) {
                        dockerClient.removeService(serviceId);
                        ++cleaned;
                        continue;
                    }
                    LOGGER.log(Level.WARNING, "Service ID is null for service: {0}", serviceName);
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.WARNING, "Failed to remove orphan service: " + serviceName, e);
                    listener.error("Failed to remove service " + serviceName + ": " + e.getMessage());
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "Error during orphan service cleanup for cloud: " + cloud.name, e);
            listener.error("Error during cleanup: " + e.getMessage());
        }
        return cleaned;
    }

    @NonNull
    private Set<String> getKnownAgentNames(Jenkins jenkins, String cloudName) {
        HashSet<String> names = new HashSet<String>();
        for (Node node : jenkins.getNodes()) {
            SwarmAgent agent;
            if (!(node instanceof SwarmAgent) || !cloudName.equals((agent = (SwarmAgent)node).getCloudName())) continue;
            names.add(agent.getNodeName());
        }
        return names;
    }

    public static int cleanupNow(SwarmCloud cloud) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return 0;
        }
        OrphanServiceCleaner cleaner = jenkins.getExtensionList(OrphanServiceCleaner.class).stream().findFirst().orElse(null);
        if (cleaner == null) {
            return 0;
        }
        return cleaner.cleanOrphanServices(cloud, jenkins, TaskListener.NULL);
    }
}

