/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.swarmcloud;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Queue;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import io.jenkins.plugins.swarmcloud.SwarmAgentTemplate;
import io.jenkins.plugins.swarmcloud.SwarmCloud;
import io.jenkins.plugins.swarmcloud.SwarmComputerLauncher;
import io.jenkins.plugins.swarmcloud.SwarmRetentionStrategy;
import io.jenkins.plugins.swarmcloud.monitoring.SwarmAuditLog;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class SwarmAgent
extends AbstractCloudSlave {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(SwarmAgent.class.getName());
    private static final int DEFAULT_IDLE_MINUTES = 10;
    private final String cloudName;
    private final String serviceId;
    private final String templateName;
    private final long createdTime;

    @DataBoundConstructor
    public SwarmAgent(@NonNull String name, @NonNull SwarmAgentTemplate template, @NonNull String cloudName, @NonNull String serviceId) throws Descriptor.FormException, IOException {
        this(name, template, cloudName, serviceId, 10);
    }

    public SwarmAgent(@NonNull String name, @NonNull SwarmAgentTemplate template, @NonNull String cloudName, @NonNull String serviceId, int idleMinutes) throws Descriptor.FormException, IOException {
        super(name, "Swarm Agent " + name, template.getRemoteFs(), template.getNumExecutors(), template.getMode(), template.getLabelString(), (ComputerLauncher)new SwarmComputerLauncher(cloudName, template.getImage(), true, null, template.getRemoteFs(), template.getConnectionTimeoutSeconds()), (RetentionStrategy)new SwarmRetentionStrategy(idleMinutes > 0 ? idleMinutes : 10), Collections.emptyList());
        this.cloudName = cloudName;
        this.serviceId = serviceId;
        this.templateName = template.getName();
        this.createdTime = System.currentTimeMillis();
    }

    protected Object readResolve() {
        return super.readResolve();
    }

    @NonNull
    public String getCloudName() {
        return this.cloudName;
    }

    @NonNull
    public String getServiceId() {
        return this.serviceId;
    }

    @NonNull
    public String getTemplateName() {
        return this.templateName;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    @Nullable
    public SwarmCloud getCloud() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            for (Cloud cloud : jenkins.clouds) {
                if (!(cloud instanceof SwarmCloud) || !cloud.name.equals(this.cloudName)) continue;
                return (SwarmCloud)cloud;
            }
        }
        return null;
    }

    @Nullable
    public SwarmAgentTemplate getTemplate() {
        SwarmCloud cloud = this.getCloud();
        if (cloud != null) {
            for (SwarmAgentTemplate template : cloud.getTemplates()) {
                if (!template.getName().equals(this.templateName)) continue;
                return template;
            }
        }
        return null;
    }

    public AbstractCloudComputer<?> createComputer() {
        return new SwarmComputer(this);
    }

    protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
        block10: {
            SwarmCloud cloud;
            PrintStream logger = listener.getLogger();
            LOGGER.log(Level.FINE, "Terminating Swarm agent: {0}, service: {1}", new Object[]{this.name, this.serviceId});
            String terminationReason = "Manual termination";
            Computer computer = this.toComputer();
            if (computer != null) {
                OfflineCause offlineCause;
                if (computer.isIdle()) {
                    terminationReason = "Idle timeout";
                } else if (computer.isOffline() && (offlineCause = computer.getOfflineCause()) != null) {
                    terminationReason = offlineCause.toString();
                }
            }
            if ((cloud = this.getCloud()) != null) {
                SwarmAgentTemplate template = this.getTemplate();
                if (template != null) {
                    template.decrementInstances();
                    LOGGER.log(Level.FINE, "Decremented instance count for template: {0}", this.templateName);
                }
                try {
                    cloud.getDockerClient().removeService(this.serviceId);
                    LOGGER.log(Level.FINE, "Removed Docker Swarm service: {0}", this.serviceId);
                    SwarmAuditLog.logTermination(this.cloudName, this.name, this.serviceId, terminationReason);
                }
                catch (Exception e) {
                    if (e.getMessage() != null && e.getMessage().contains("not found")) {
                        logger.println("Service already removed: " + this.serviceId);
                        LOGGER.log(Level.FINE, "Service already removed: {0}", this.serviceId);
                        SwarmAuditLog.logTermination(this.cloudName, this.name, this.serviceId, "Service already removed");
                        break block10;
                    }
                    LOGGER.log(Level.WARNING, "Failed to remove Docker Swarm service: " + this.serviceId, e);
                    logger.println("Warning: Failed to remove service: " + e.getMessage());
                }
            } else {
                LOGGER.log(Level.WARNING, "Cloud not found for agent: {0}, cloud name: {1}", new Object[]{this.name, this.cloudName});
                logger.println("Warning: Cloud not found, service may need manual cleanup: " + this.serviceId);
                SwarmAuditLog.logTermination(this.cloudName, this.name, this.serviceId, "Cloud not found");
            }
        }
    }

    public static class SwarmComputer
    extends AbstractCloudComputer<SwarmAgent> {
        private static final Logger COMPUTER_LOGGER = Logger.getLogger(SwarmComputer.class.getName());

        public SwarmComputer(SwarmAgent agent) {
            super((AbstractCloudSlave)agent);
        }

        public void taskAccepted(Executor executor, Queue.Task task) {
            super.taskAccepted(executor, task);
            COMPUTER_LOGGER.log(Level.FINE, "Task accepted on Swarm agent: {0}, task: {1}", new Object[]{this.getName(), task.getFullDisplayName()});
        }

        public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
            super.taskCompleted(executor, task, durationMS);
            COMPUTER_LOGGER.log(Level.FINE, "Task completed on Swarm agent: {0}, task: {1}, duration: {2}ms", new Object[]{this.getName(), task.getFullDisplayName(), durationMS});
        }

        public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
            super.taskCompletedWithProblems(executor, task, durationMS, problems);
            COMPUTER_LOGGER.log(Level.WARNING, "Task completed with problems on Swarm agent: {0}, task: {1}", new Object[]{this.getName(), task.getFullDisplayName()});
        }

        @Nullable
        public SwarmAgent getNode() {
            return (SwarmAgent)super.getNode();
        }

        @Nullable
        public String getServiceId() {
            SwarmAgent node = this.getNode();
            return node != null ? node.getServiceId() : null;
        }

        @Nullable
        public String getCloudName() {
            SwarmAgent node = this.getNode();
            return node != null ? node.getCloudName() : null;
        }

        public String toString() {
            return "SwarmComputer{name=" + this.getName() + ", serviceId=" + this.getServiceId() + ", cloudName=" + this.getCloudName() + "}";
        }
    }

    @Extension
    @Symbol(value={"swarmAgent"})
    public static class DescriptorImpl
    extends Slave.SlaveDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Docker Swarm Agent";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

