/*
 * Decompiled with CFR 0.152.
 */
package com.simplifyqa;

import com.simplifyqa.ExecutionImpl;
import com.simplifyqa.Services.ExecutionServices;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.json.simple.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class SQAPipelineBuilder
extends Builder
implements SimpleBuildStep {
    private String execToken;
    private String appUrl;
    private double threshold;
    private boolean verbose;

    @DataBoundSetter
    public void setExecToken(String execToken) {
        this.execToken = execToken;
    }

    @DataBoundSetter
    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    @DataBoundSetter
    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    @DataBoundSetter
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @DataBoundConstructor
    public SQAPipelineBuilder(String execToken, String appUrl, double threshold, boolean verbose) {
        this.execToken = execToken;
        this.appUrl = appUrl;
        this.threshold = threshold;
        this.verbose = verbose;
    }

    public String getExecToken() {
        return this.execToken;
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        ExecutionServices exec_dto = new ExecutionServices();
        if (this.execToken == null || this.execToken.isBlank()) {
            run.setResult(Result.NOT_BUILT);
            exec_dto.printLog(ExecutionServices.getTimestamp() + "Execution token must not be empty\n");
            exec_dto.printLog(ExecutionServices.getTimestamp() + "*".repeat(51) + "EOF" + "*".repeat(51) + "\n");
            return;
        }
        ExecutionImpl exec_obj = new ExecutionImpl(this.execToken, this.appUrl, this.threshold, this.verbose, listener);
        exec_dto.setExecObj(exec_obj);
        run.addAction((Action)exec_obj);
        if (!exec_dto.startExec()) {
            run.setResult(Result.NOT_BUILT);
        } else {
            int totalSteps;
            String result;
            String tcName;
            String tcCode;
            int executed = exec_obj.getExecutedTcs();
            if (exec_obj.getVerbose()) {
                exec_dto.printLog(exec_obj.getReqBody() + exec_obj.getRespBody() + "\n");
            }
            while (exec_dto.checkExecStatus().equalsIgnoreCase("INPROGRESS") && exec_obj.getThreshold() > exec_obj.getFailPercent()) {
                if (executed >= exec_obj.getExecutedTcs()) continue;
                ++executed;
                exec_dto.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Execution " + exec_obj.getExecStatus() + " for Suite ID: SU-" + exec_obj.getCustomerId() + exec_obj.getSuiteId() + "\n");
                exec_dto.printLog(" ".repeat(27) + "(Executed " + exec_obj.getExecutedTcs() + " of " + exec_obj.getTotalTcs() + " testcase(s), execution percentage: " + exec_obj.getExecPercent() + " %)");
                exec_dto.printLog("\n" + " ".repeat(27) + "(Failed " + exec_obj.getTcsFailed() + " of " + exec_obj.getTotalTcs() + " testcase(s), fail percentage: " + exec_obj.getFailPercent() + " %)");
                exec_dto.printLog("\n" + " ".repeat(27) + "(Threshold: " + exec_obj.getThreshold() + " % i.e. " + exec_obj.getThreshold() / 100.0 * (double)Double.valueOf(exec_obj.getTotalTcs()).intValue() + " of " + exec_obj.getTotalTcs() + " testcase(s))\n");
                for (Object item : exec_obj.getResults()) {
                    tcCode = ((JSONObject)item).get((Object)"tcCode").toString();
                    tcName = ((JSONObject)item).get((Object)"tcName").toString();
                    result = ((JSONObject)item).get((Object)"result").toString().toUpperCase();
                    totalSteps = Integer.parseInt(((JSONObject)item).get((Object)"totalSteps").toString());
                    exec_dto.printLog(" ".repeat(27) + tcCode + ": " + tcName + " | TESTCASE " + result + " (total steps: " + totalSteps + ")\n");
                }
                if (exec_obj.getVerbose()) {
                    exec_dto.printLog(exec_obj.getReqBody() + exec_obj.getRespBody() + "\n");
                }
                if (!(exec_obj.getThreshold() <= exec_obj.getFailPercent())) continue;
                exec_dto.printLog("\n" + ExecutionServices.getTimestamp() + "THRESHOLD REACHED!!!");
                exec_obj.setExecStatus("FAILED");
                break;
            }
            exec_dto.checkExecStatus();
            exec_dto.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Execution " + exec_obj.getExecStatus() + " for Suite ID: SU-" + exec_obj.getCustomerId() + exec_obj.getSuiteId() + "\n");
            exec_dto.printLog(" ".repeat(27) + "(Executed " + exec_obj.getExecutedTcs() + " of " + exec_obj.getTotalTcs() + " testcase(s), execution percentage: " + exec_obj.getExecPercent() + " %)");
            exec_dto.printLog("\n" + " ".repeat(27) + "(Failed " + exec_obj.getTcsFailed() + " of " + exec_obj.getTotalTcs() + " testcase(s), fail percentage: " + exec_obj.getFailPercent() + " %)");
            exec_dto.printLog("\n" + " ".repeat(27) + "(Threshold: " + exec_obj.getThreshold() + " % i.e. " + exec_obj.getThreshold() / 100.0 * (double)Double.valueOf(exec_obj.getTotalTcs()).intValue() + " of " + exec_obj.getTotalTcs() + " testcase(s))\n");
            for (Object item : exec_obj.getResults()) {
                tcCode = ((JSONObject)item).get((Object)"tcCode").toString();
                tcName = ((JSONObject)item).get((Object)"tcName").toString();
                result = ((JSONObject)item).get((Object)"result").toString().toUpperCase();
                totalSteps = Integer.parseInt(((JSONObject)item).get((Object)"totalSteps").toString());
                exec_dto.printLog(" ".repeat(27) + tcCode + ": " + tcName + " | TESTCASE " + result + " (total steps: " + totalSteps + ")\n");
            }
            if (exec_obj.getVerbose()) {
                exec_dto.printLog(exec_obj.getReqBody() + exec_obj.getRespBody() + "\n");
            }
            if (exec_obj.getThreshold() <= exec_obj.getFailPercent()) {
                exec_dto.printLog(ExecutionServices.getTimestamp() + "EXECUTION FAILED!!");
                if (exec_dto.killExec()) {
                    exec_dto.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: SUCCESSFUL to explicitly kill the execution!\n");
                } else {
                    exec_dto.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: FAILED to explicitly kill the execution!\n");
                }
                if (exec_obj.getVerbose()) {
                    exec_dto.printLog(exec_obj.getReqBody() + exec_obj.getRespBody() + "\n");
                }
                run.setResult(Result.FAILURE);
            } else {
                exec_dto.printLog(ExecutionServices.getTimestamp() + "EXECUTION PASSED!!");
                run.setResult(Result.SUCCESS);
            }
            exec_dto.printLog(ExecutionServices.getTimestamp() + "REPORT URL: " + exec_obj.getReportUrl() + "\n");
        }
        exec_dto.printLog(ExecutionServices.getTimestamp() + "*".repeat(51) + "EOF" + "*".repeat(51) + "\n");
    }

    @Symbol(value={"SQAPipelineExecutor"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        @RequirePOST
        public FormValidation doCheckExec_token(@QueryParameter String value) throws IOException, ServletException {
            ArrayList<FormValidation> validationList = new ArrayList<FormValidation>();
            validationList.add(FormValidation.error((String)"Execution token must not be empty"));
            validationList.add(FormValidation.validateRequired((String)value));
            if (value.length() < 1) {
                return FormValidation.aggregate(validationList);
            }
            if (value.length() != 88) {
                return FormValidation.error((String)"Execution token must be exactly 88 characters");
            }
            return FormValidation.ok((String)"Valid Execution Token");
        }

        @RequirePOST
        public FormValidation doCheckApp_url(@QueryParameter String value) throws IOException, ServletException, URISyntaxException {
            ArrayList<FormValidation> validationList = new ArrayList<FormValidation>();
            validationList.add(FormValidation.error((String)"App URL must not be empty"));
            validationList.add(FormValidation.validateRequired((String)value));
            if (value.isBlank()) {
                return FormValidation.aggregate(validationList);
            }
            if (!(value.startsWith("http://") ^ value.startsWith("https://") ^ value.startsWith("localhost:"))) {
                return FormValidation.warning((String)"Invalid App URL (must start with http://, https:// or localhost:)");
            }
            if (ExecutionServices.getResponse(value, "GET", "").statusCode() != 200) {
                return FormValidation.warning((String)"App URL is unreachable");
            }
            return FormValidation.ok((String)"Valid App Url");
        }

        public FormValidation doCheckThreshold(@QueryParameter double value) throws IOException, ServletException {
            if (value < 1.0 || value > 100.0) {
                return FormValidation.warning((String)"Threshold must be between 1 and 100");
            }
            return FormValidation.ok((String)"Valid Threshold");
        }

        public String getConfigPage() {
            return "/SQAPipelineBuilder/config.jelly";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "SimplifyQA (Old UI Executor)";
        }
    }
}

