/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remote.result.trigger;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.remote.result.trigger.RemoteJenkinsServer;
import io.jenkins.plugins.remote.result.trigger.model.ResultCheck;
import io.jenkins.plugins.remote.result.trigger.utils.RemoteJenkinsServerUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import lombok.Generated;
import net.sf.json.util.JSONUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class RemoteJobInfo
implements Describable<RemoteJobInfo>,
Serializable {
    private static final long serialVersionUID = -7232627326475916056L;
    private static final String[] ALL_BUILD_RESULT = new String[]{"SUCCESS", "UNSTABLE", "FAILURE", "NOT_BUILT", "ABORTED"};
    private String id;
    private String remoteServer;
    @Deprecated
    private String remoteJobName;
    private String remoteJobUrl;
    private String uid;
    private List<String> triggerResults = new ArrayList<String>();
    private List<ResultCheck> resultChecks = new ArrayList<ResultCheck>();

    @DataBoundConstructor
    public RemoteJobInfo() {
    }

    public Descriptor<RemoteJobInfo> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    @DataBoundSetter
    public void setRemoteServer(String remoteServer) {
        this.remoteServer = remoteServer;
    }

    @Deprecated
    public String getRemoteJobName() {
        return this.remoteJobName;
    }

    public String getRemoteJobUrl() {
        if (this.remoteJobUrl == null && this.remoteJobName != null && this.remoteServer != null) {
            RemoteJenkinsServer remoteServer = RemoteJenkinsServerUtils.getRemoteJenkinsServer(this.getRemoteServer());
            return remoteServer.getUrl() + (remoteServer.getUrl().endsWith("/") ? "" : "/") + this.remoteJobName;
        }
        return this.remoteJobUrl;
    }

    @DataBoundSetter
    public void setRemoteJobUrl(String remoteJobUrl) {
        this.remoteJobUrl = remoteJobUrl;
    }

    @DataBoundSetter
    public void setRemoteJobName(String remoteJobName) {
        this.remoteJobName = remoteJobName;
    }

    @DataBoundSetter
    public void setUid(String uid) {
        this.uid = StringUtils.isEmpty((String)uid) ? RandomStringUtils.randomAlphabetic((int)32) : uid;
    }

    @DataBoundSetter
    public void setResultChecks(List<ResultCheck> resultChecks) {
        this.resultChecks = resultChecks;
    }

    public Boolean isTriggerResultChecked(String result) {
        return this.triggerResults.contains(result);
    }

    @DataBoundSetter
    public void setTriggerResults(List<Boolean> triggerResults) {
        this.triggerResults = new ArrayList<String>();
        for (int i = 0; i < ALL_BUILD_RESULT.length; ++i) {
            if (!triggerResults.get(i).booleanValue()) continue;
            this.triggerResults.add(ALL_BUILD_RESULT[i]);
        }
    }

    public void updateId() {
        this.setId(DigestUtils.sha256Hex((String)(this.remoteServer + this.getRemoteJobUrl() + this.uid + JSONUtils.valueToString(this.triggerResults) + JSONUtils.valueToString(this.resultChecks))));
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getRemoteServer() {
        return this.remoteServer;
    }

    @Generated
    public String getUid() {
        return this.uid;
    }

    @Generated
    public List<String> getTriggerResults() {
        return this.triggerResults;
    }

    @Generated
    public List<ResultCheck> getResultChecks() {
        return this.resultChecks;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RemoteJobInfo> {
        public static String[] getBuildResults() {
            return ALL_BUILD_RESULT;
        }

        @POST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckRemoteServer(@QueryParameter String remoteServer) {
            if (StringUtils.isEmpty((String)remoteServer)) {
                return FormValidation.error((String)"Please select a remote Jenkins Server");
            }
            return FormValidation.ok();
        }

        @POST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckRemoteJobUrl(@QueryParameter String remoteJobUrl) {
            if (StringUtils.isEmpty((String)remoteJobUrl)) {
                return FormValidation.error((String)"Please enter a remote job url");
            }
            return FormValidation.ok();
        }

        @POST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckUid(@QueryParameter String uid) {
            if (StringUtils.isNotEmpty((String)uid) && !uid.matches("[a-zA-Z0-9./_-]*")) {
                return FormValidation.error((String)"Only support [a-zA-Z0-9./_-] characters");
            }
            return FormValidation.ok();
        }

        @POST
        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillRemoteServerItems(@QueryParameter String remoteJenkinsServer) {
            RemoteJenkinsServer[] servers;
            ListBoxModel model = new ListBoxModel();
            model.add("");
            for (RemoteJenkinsServer server : servers = RemoteJenkinsServerUtils.getRemoteServers()) {
                String key;
                String string = key = StringUtils.isNotEmpty((String)server.getDisplayName()) ? server.getDisplayName() : server.getUrl();
                if (server.getId() == null || key == null || !Jenkins.get().hasPermission(Jenkins.READ) && !StringUtils.equals((String)server.getId(), (String)remoteJenkinsServer)) continue;
                model.add(key, server.getId());
            }
            return model;
        }
    }
}

