/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remote.result.trigger;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Run;
import io.jenkins.plugins.remote.result.trigger.RemoteBuildResultTriggerScheduledAction;
import io.jenkins.plugins.remote.result.trigger.model.JobResultInfo;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ReadRemoteResultStep
extends Step {
    private String uid;

    @DataBoundConstructor
    public ReadRemoteResultStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new ReadRemoteResultStepExecution(this, context);
    }

    @DataBoundSetter
    public void setUid(String uid) {
        this.uid = uid;
    }

    @Generated
    public String getUid() {
        return this.uid;
    }

    public static class ReadRemoteResultStepExecution
    extends SynchronousNonBlockingStepExecution<Map<?, ?>> {
        private static final long serialVersionUID = 4436899316471397907L;
        private final transient ReadRemoteResultStep step;

        public ReadRemoteResultStepExecution(@NonNull ReadRemoteResultStep step, @NonNull StepContext context) {
            super(context);
            this.step = step;
        }

        protected Map<?, ?> run() throws Exception {
            JobResultInfo jobInfo;
            RemoteBuildResultTriggerScheduledAction action = this.getTriggerAction();
            if (action != null && !action.getJobResultInfos().isEmpty() && (jobInfo = StringUtils.isEmpty((String)this.step.getUid()) ? action.getJobResultInfos().get(0) : (JobResultInfo)action.getJobResultInfos().stream().filter(item -> this.step.getUid().equals(item.getUid())).findFirst().orElse(null)) != null) {
                return jobInfo.getRemoteResult();
            }
            return new HashMap();
        }

        @Nullable
        private RemoteBuildResultTriggerScheduledAction getTriggerAction() throws IOException, InterruptedException {
            Run run = (Run)this.getContext().get(Run.class);
            if (run != null) {
                return (RemoteBuildResultTriggerScheduledAction)run.getAction(RemoteBuildResultTriggerScheduledAction.class);
            }
            return null;
        }
    }

    @Extension
    public static class ReadRemoteResultStepDescriptor
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(Run.class);
        }

        public String getFunctionName() {
            return "readRemoteResult";
        }
    }
}

