/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.prism;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.FormValidation;
import io.jenkins.plugins.prism.SourceDirectoryValidation;
import io.jenkins.plugins.util.JenkinsFacade;
import java.io.Serializable;
import java.util.Objects;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public final class SourceCodeDirectory
implements Describable<SourceCodeDirectory>,
Serializable {
    private static final long serialVersionUID = -9108340338391937915L;
    private final String path;

    @DataBoundConstructor
    public SourceCodeDirectory(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceCodeDirectory that = (SourceCodeDirectory)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SourceCodeDirectory> {
        private static final JenkinsFacade JENKINS = new JenkinsFacade();
        private static final SourceDirectoryValidation VALIDATION = new SourceDirectoryValidation();

        @NonNull
        public String getDisplayName() {
            return "";
        }

        @POST
        public FormValidation doCheckPath(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String path) {
            if (!JENKINS.hasPermission(Item.CONFIGURE, project)) {
                return FormValidation.ok();
            }
            return VALIDATION.validateSourceDirectory(project, path);
        }
    }
}

