/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils;

import com.fasterxml.jackson.annotation.JsonValue;
import hudson.model.Result;
import io.jenkins.plugins.pipelinegraphview.utils.BlueRun;
import io.jenkins.plugins.pipelinegraphview.utils.NodeRunStatus;
import java.util.Locale;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public enum PipelineState {
    QUEUED,
    RUNNING,
    PAUSED,
    SKIPPED,
    NOT_BUILT,
    FINISHED,
    SUCCESS,
    UNSTABLE,
    FAILURE,
    UNKNOWN,
    ABORTED;


    public boolean isInProgress() {
        return this == RUNNING || this == QUEUED || this == PAUSED;
    }

    public static PipelineState of(WorkflowRun run) {
        Result result = run.getResult();
        if (result == Result.SUCCESS) {
            return SUCCESS;
        }
        if (result == Result.UNSTABLE) {
            return UNSTABLE;
        }
        if (result == Result.FAILURE) {
            return FAILURE;
        }
        if (result == Result.NOT_BUILT) {
            return NOT_BUILT;
        }
        if (result == Result.ABORTED) {
            return ABORTED;
        }
        if (run.isInProgress()) {
            return RUNNING;
        }
        return UNKNOWN;
    }

    public static PipelineState of(NodeRunStatus status) {
        if (status.getState() == BlueRun.BlueRunState.FINISHED) {
            return switch (status.getResult()) {
                default -> throw new IncompatibleClassChangeError();
                case BlueRun.BlueRunResult.SUCCESS -> SUCCESS;
                case BlueRun.BlueRunResult.UNSTABLE -> UNSTABLE;
                case BlueRun.BlueRunResult.FAILURE -> FAILURE;
                case BlueRun.BlueRunResult.NOT_BUILT -> NOT_BUILT;
                case BlueRun.BlueRunResult.UNKNOWN -> UNKNOWN;
                case BlueRun.BlueRunResult.ABORTED -> ABORTED;
            };
        }
        return switch (status.getState()) {
            default -> throw new IncompatibleClassChangeError();
            case BlueRun.BlueRunState.QUEUED -> QUEUED;
            case BlueRun.BlueRunState.RUNNING -> RUNNING;
            case BlueRun.BlueRunState.PAUSED -> PAUSED;
            case BlueRun.BlueRunState.SKIPPED -> SKIPPED;
            case BlueRun.BlueRunState.NOT_BUILT -> NOT_BUILT;
            case BlueRun.BlueRunState.FINISHED -> FINISHED;
        };
    }

    @JsonValue
    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

