/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.multipipelinegraphview;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.model.Action;
import hudson.model.Item;
import hudson.security.Permission;
import hudson.util.HttpResponses;
import hudson.util.RunList;
import io.jenkins.plugins.pipelinegraphview.PipelineGraphViewConfiguration;
import io.jenkins.plugins.pipelinegraphview.multipipelinegraphview.PipelineRun;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import org.jenkins.ui.icon.IconSpec;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.verb.GET;

public class MultiPipelineGraphViewAction
implements Action,
IconSpec {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int MaxNumberOfElements = 10;
    private final WorkflowJob target;

    public MultiPipelineGraphViewAction(WorkflowJob target) {
        this.target = target;
    }

    public String getJobDisplayName() {
        return this.target.getDisplayName();
    }

    public boolean isBuildable() {
        return this.target.isBuildable();
    }

    public Permission getPermission() {
        return Item.BUILD;
    }

    public Permission getConfigurePermission() {
        return Item.CONFIGURE;
    }

    public boolean isShowGraphOnJobPage() {
        return PipelineGraphViewConfiguration.get().isShowGraphOnJobPage();
    }

    public boolean isShowStageNames() {
        return PipelineGraphViewConfiguration.get().isShowStageNames();
    }

    public boolean isShowStageDurations() {
        return PipelineGraphViewConfiguration.get().isShowStageDurations();
    }

    @GET
    @WebMethod(name={"runs"})
    public HttpResponse getRuns() throws JsonProcessingException {
        RunList runs = this.target.getBuilds();
        ArrayList<PipelineRun> pipelineRuns = new ArrayList<PipelineRun>();
        for (WorkflowRun run : runs) {
            pipelineRuns.add(new PipelineRun(run));
            if (pipelineRuns.size() < 10) continue;
            break;
        }
        JSONArray graph = this.createJson(pipelineRuns);
        return HttpResponses.okJSON((JSONArray)graph);
    }

    protected JSONArray createJson(List<PipelineRun> pipelineRuns) throws JsonProcessingException {
        String graph = OBJECT_MAPPER.writeValueAsString(pipelineRuns);
        return JSONArray.fromObject((Object)graph);
    }

    public String getJobUrl() {
        return this.target.getUrl();
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "Stages";
    }

    public String getUrlName() {
        return "multi-pipeline-graph";
    }

    public String getIconClassName() {
        return "symbol-layers-outline plugin-ionicons-api";
    }
}

